<?php

/**
 * 快贷控制基类
 * */
class KDBaseAction extends BaseAction
{
	const EVENT_INSERT = 'insert';
	const EVENT_UPDATE = 'update';
	const EVENT_DELETE = 'delete';
	
	/**
	 * 新增界面
	 * */
	function add()
	{
		if(false === $this->_before_add()) return false;
		$this->display();
	}
	
	/**
	 * 修改界面
	 * */
	function edit()
	{
		$name = $this->getModelName();
		$obj = $this->getMainModel();
		$id = $_REQUEST[$obj->getPk()];
		$vo = $obj->find($id);
		if(false === $this->_before_edit($vo)) return false;
		$this->assign('vo', $vo);
		$this->display();
	}
	
	/**
	 * 删除
	 * */
	function delete($arg = '')
	{
		$isHTML = empty($arg);
		$name = $this->getModelName();
		$obj = $this->getMainModel();
		$pk = $obj->getPk();
		$id = $isHTML ? $_REQUEST[$pk] : 
				(is_array($arg) ? $arg[$pk] : $arg);
		
		if(false === $this->_before_save($id, self::EVENT_DELETE)) return false;
		
		if($id) {
			$data['delete_flag'] = 1;
			$data['deleter'] = $_SESSION['user']['account'];
			$data['deleted_time'] = time();
			$id = explode(",", $id);
			$con = array( $pk=>array('in',$id) );
			$res = $obj->where($con)->data($data)->save();
			$data['_con'] = $con;
			if( (false !== $res) && (false !== $this->_after_save($data, self::EVENT_DELETE)))  {
				return $this->_message($isHTML,'删除成功', false);
			} else {
				return $this_message($isHTML,'删除失败');
			}
		}
		empty($arg) && $this->forward();
	}
	
	/**
	 * 保存
	 * @param $arr array 用于生成SQL的参数
	 * @param array $where 额外的条件参数，一般用于无法提供主键时
	 * */
	function save($arr = '', $where=array())
	{
		$isHtml = empty($arr);
		$name = $this->getModelName();
		$obj = $this->getMainModel();
		
		if(false === ($data=$obj->create($arr))) {
			return $this->_message($isHtml, $obj->getError());
		}
		
		$data['WHERE'] = $where;
		if(false === $this->_before_save($data, self::EVENT_UPDATE)) {
			return $this->_message($isHtml, $this->getErrorString() );
		}
		
		
		
		if(!empty($where)) {
			$obj->where($where);
		}
		if(false !==($res=$obj->data($data)->save()) 
			&& (false !== $this->_after_save($data, self::EVENT_UPDATE))) 
		{
			//$isHtml && $this->assign('jumpUrl', Cookie('_currentUrl_'));
			$this->_message($isHtml, '保存成功', false);
			return $data;
		} else {
			return $this->_message($isHtml, '保存失败');
		}
	}
	
	/**
	 * 插入记录
	 * */
	function insert($arr = '')
	{
		$isHTML = empty($arr);
		$obj = $this->getMainModel();
		
		if(false === ($data = $obj->create($arr))) {
			return $this->_message($isHTML, $obj->getError() );
		}
		if(false === $this->_before_save($data, self::EVENT_INSERT)) {
			return $this->_message($isHTML, $this->getErrorString());
		}
		
		$res = $obj->data($data)->add();
		$data['id'] = $res;
		$data[$obj->getPK()] = $res;
		if((false !== $res) && (false !==$this->_after_save($data, self::EVENT_INSERT))) {
			$isHTML && $this->assign('jumpUrl', Cookie('_currentUrl_'));
			$this->_message($isHTML, '新增成功', false);
			return $res;
		} else {
			return $this->_message($isHTML, '新增失败');
		}
	}
	
	/**
	 * 发送系统信息
	 * @param string $sign remind 表中的sign字段值
	 * @param array $arrUser 会员数组
	 * @param string $content 信息内容
	 * @param string $title (可选)信息标题
	 * @param boolean
	 * */
	function sendSystemMessage($sign, $arrUser, $content, $title='系统信息')
	{
		$data = $this->_makeSystemMessage($arrUser, $content, $title);
		$obj = $this->_A('Remind');
		try {
			return $obj->send($data['notice'], $data['email'], $data['mobile'], $sign);
		} catch (Exception $e) {
			return false;
		}
	}
	
	/**
	 * 生成系统发送信息所需的数据
	 * @param array $arrUser 接收人信息
	 * @param string $content 信息内容
	 * @param string $title （可选）信息标题
	 * @return array
	 * */
	protected function _makeSystemMessage($arrUser, $content, $title='系统信息')
	{
		 $noticeData = array("tid"=>1,//默认1
		     "title"=>$title,
		     "content"=>$content,
		     "fuserid"=>0,
		     "fusername"=>"系统管理员",
		     "tuserid"=>$arrUser['user_id'],
		     "tusername"=>$arrUser['username'],
		     "add_time"=>date("Y-m-d H:i:s"),
		     
		 );
		 
		 $emailData = array("mailto"=>$arrUser['email'],
				    "subject"=>$title,
				    "body"=>$content, 	 
		 );
		 
		 
		 //去除手机短信内容中的html标签
		 $content = strip_tags($content);
		 $mobileData =array("user_id"=>$arrUser['user_id'],
				      "type"=>"common",  //类型
				      "phone"=>$arrUser['mobile'],
				      "status"=>0,
				      "contents"=>$content,
				      "send_code"=>"",
				      "send_status"=>0,
				      "send_time"=>time(),
				      "send_url"=>"",
				      "code"=>"",
				      "addtime"=>time(),
				      "addip"=>get_client_ip(),
			);
		return array('notice'=>$noticeData, 'email'=>$emailData, 'mobile'=>$mobileData);
	}
	
	/**
	 * 编辑预处理
	 * @param $data 按引用传参
	 * @return null/boolean 若是返回布尔值 false 后继程序将被中止
	 * */
	protected function _before_edit(&$data = array()){}
	
	/**
	 * 新增预处理
	 * @return null/boolean 若是返回布尔值 false 后继程序将被中止
	 * */
	protected function _before_add(){}
	
	/**
	 * 数据保存预处理
	 * @param $data 按引用传参
	 * @param $type 事件触发类型可选值：EVENT_INSERT和EVENT_UPDATE，默认：EVENT_INSERT
	 * @return null/boolean 若是返回布尔值 false 后继程序将被中止
	 * */
	protected function _before_save(&$data = array(), $type=self::EVENT_INSERT) {}
	
	/**
	 * 数据保存后补处理
	 * @param $data 按引用传参
	 * @param $type 事件触发类型可选值：EVENT_INSERT和EVENT_UPDATE，默认：EVENT_INSERT
	 * @return null/boolean 若是返回布尔值 false 后继程序将被中止
	 * */
	protected function _after_save(&$data = array(), $type=self::EVENT_INSERT) {}
	
	
	/**
	 * 消息显示
	 * @param $isHTML boolean 是否以HTML方式显示
	 * @param $str string 需要显示的消息
	 * @param $isError boolean 是否是错误消息，默认：true
	 * @return boolean
	 * */
	protected function _message($isHTML, $str, $isError=true)
	{
		if($isHTML) {
			$tp = $isError ? 'error' : 'success';
			$this->$tp($str);
		} else {
			$this->setError($str);
			return $isError ? false : true;
		}
	}
	
	/**
	 * 公用数据查询
	 * @param Object#Model $model (必选)查询数据库模型, $model 应在传入前完成order 和 relation 参数
	 * @param array $map (可选)查询条件
	 * @param array $urlArr (可选)用于生成 分页链接条件的条件组
	 * @param int $listRows (可选)每页的显示记录数，默认:20
	 * @param boolean $isPage (可选)是否需要分页，默认:true
	 * @param boolean $isGroupRow (可选)是否需要按照分组后统计记录行数
	 * @return false/array
	 * */
	protected function _SH($model, $urlArr=array(), $listRows=20, $isPage=true, $isGroupRow=false)
	{
		if($isPage) {
			$obj = clone($model);
			if($isGroupRow) { //按照分组后统计记录行数
				$str = $obj->order("")->select(false);
				$sql = "select count(*) as tp_count from {$str} a";
				$rs = $obj->query($sql); 
				$len = intval($rs[0]['tp_count']);
			} else {
				$obj->order("");
	    		$len = $obj->count();
			}
	    	unset($obj);
	    	
	    	import("ORG.Util.Page");
	    	$listRows = intval($listRows);
	    	$listRows<1 && $listRows = 20;
	    	$objPage = new Page($len, $listRows);
	    	$parameter = array();
	    	foreach ($urlArr as $k=>$v) {
	    		$parameter[] = "{$k}={$v}";
	    	}
	    	$objPage->parameter = implode("&", $parameter);
	    	
	    	$model->limit($objPage->firstRow,$objPage->listRows);
	    	
	   		$show = $objPage->Show();
	    	$this->assign('page', $show);
	    	$this->assign('pageObj', $objPage);
		}
     	$res = $model->select();
    	$this->assign("list", $res);
    	
    	return $res;
	}
	
}

?>