<?php
class ProcessBar
{
	protected static $_max = 0;
	public static $_err = "";
	
	/**
	 * 消息打印到浏览器
	 * @param array $arr 需要打印的消息数组
	 * @param boolean $isCount 是否为进度计数，默认：false
	 * @return void
	 * */
	static function show($arr=array(), $isCount=false)
	{
		isset($arr['info']) && self::$_err = $arr['info'];
		
		$flag = "";
		$isCount && $flag='class="s_proccess_counter"';
		
		$arr['max'] = self::$_max;
		$str = json_encode($arr);
		echo str_repeat(' ', 4096)."<p {$flag}>{$str}</p>";
		@ob_flush();
		flush();
	}
	
	/**
	 * 进度计数
	 * @param mix $msg 可以为空，也可以接受 array 和 string 两种类型
	 * @return void
	 * */
	static function count($msg='')
	{
		$arr = array();
		if(is_array($msg)) {
			$arr = $msg;
		} elseif (!empty($msg)) {
			$arr['info'] = $msg;
		}
		self::show($arr, true);
	}
	
	/**
	 * 设置总数
	 * @param int $val
	 * @return void
	 * */
	static function setMax($val)
	{
		self::$_max = $val;
	}
	
	/**
	 * 错误消息，程序执行到此会被中止
	 * @param string $msg 错误提示消息
	 * @param boolean $isCount 是否为进度计数，默认：false
	 * @return void
	 * */
	static function error($msg, $isCount=false)
	{
		$arr['info'] = $msg;
		$arr['status'] = 0;
		self::show($arr, $isCount);
		exit();
	}
	
	/**
	 * 成功消息，程序执行到此会被中止
	 * @param string $msg 成功提示消息
	 * @param boolean $isCount 是否为进度计数，默认：false
	 * @return void
	 * */
	static function success($msg, $isCount=false)
	{
		$arr['info'] = $msg;
		$arr['status'] = 1;
		self::show($arr, $isCount);
		exit();
	}
	
	/**
	 * 提示消息
	 * @param string $msg 提示消息
	 * @param boolean $isCount 是否为进度计数，默认：false
	 * @return void
	 * */
	static function msg($msg, $isCount=false)
	{
		$arr['info'] = $msg;
		self::show($arr, $isCount);
	}
	
	/**
	 * 错误消息，并返回 false
	 * @param string $msg 错误消息
	 * @param boolean $isCount 是否为进度计数，默认：false
	 * @return boolean false
	 * */
	static function returnError($msg, $isCount=false)
	{
		$arr['info'] = $msg;
		$arr['status'] = 0;
		self::show($arr, $isCount);
		return false;
	}
	
	/**
	 * 成功消息，并返回 true
	 * @param string $msg 成功消息
	 * @param boolean $isCount 是否为进度计数，默认：false
	 * @return boolean true
	 * */
	static function returnSuccess($msg, $isCount=false)
	{
		$arr['info'] = $msg;
		$arr['status'] = 1;
		self::show($arr, $isCount);
		return true;
	}
}
?>