<?php
//资金模型
class AccountModel extends CommonModel {
	
	//获取资金类型列表
	function getMoneyType(){
		 $rs=$this->table(''.$this->tablePrefix.'money_type')->select();
	     return $rs;
	}
	
   //资金类型树形结构
	function getMoneyTypeTree($nowid="0",$type=""){
		if($type==1){
			//用户费用
			$sql = " where is_user_fee=1";
		}else if($type==2){
			//网站费用
			$sql = " where is_web_fee=1";
		}else{
			$sql="";
		}
		$rs = $this->db->query('select * from '.$this->tablePrefix.'money_type'.$sql);
		$abce.="&nbsp;&nbsp;";
		if($rs){
			foreach($rs as $array){
				if($nowid==$array[type_id]) {
						$output.= "<OPTION value=\"".$array[type_id]."\" selected>".$array[name]."</OPTION>\n";
				}else {
					    $output.= "<OPTION value=\"".$array[type_id]."\" >".$array[name]."</OPTION>\n";
				}
			}
		}
		return $output;
	}
	
	
	/*
	 * 获取用户账号信息
	 * @param int $userid
	 * @return array
	 */
    function getAccout($userid){
    	if(intval($userid)>0){
    		$rs=$this->table(''.$this->tablePrefix.'account')->where(array("user_id"=>$userid))->find();
    		return $rs;
    	}
    }
    
    /*
     * 获取用户主表信息
     * @param int $userid
     * @return array
     */
    function getUser($userid){
    	if(intval($userid)>0){
    		$rs=$this->table(''.$this->tablePrefix.'user')->where(array("user_id"=>$userid))->find();
    		return $rs;
    	}
   }
    
    
    /*  
     * 资金收费标准   --查出资金类型该收多少费用
     * @param int $userid  用户
     * @param int $type_id 资金类型
     * @param int $amount  金额
     * @return float 
     */
    
    function getFee($user_id,$type_id=0,$amount){
    	if($type_id>0){
    		$money_type_fee = $this->table(''.$this->tablePrefix.'money_type_fee')->where(array("type_id"=>$type_id,"enable"=>1))->find();
    		if(empty($money_type_fee)){
                 return 0;
            }
            switch ($money_type_fee["fee_type"]){
            	case 0:
            		//免费
            		return 0;
            		break;
            	case 1:
            		//按比列
            		$user = $this->getUser($user_id);
            	   	if($user["type"]==1){
            	   		//vip
            	   		$fee = $amount*$money_type_fee["vip_account_scale"]*0.01;
            	   		//判读是否有vip最高提限制
            	   		if($money_type_fee["vip_account_scale_max"]>0 && $money_type_fee["vip_account_scale_max"]<$fee){
            	   			return $money_type_fee["vip_account_scale_max"];
            	   		}else{
            	   			return $fee;
            	   		}
            	   		
            	   	}elseif ($user["type"]==0){
            	   		//普通会员
            	   		$fee = $amount*$money_type_fee["all_account_scale"]*0.01;
            	   	    if($money_type_fee["all_account_scale_max"]>0 && $money_type_fee["vip_account_scale_max"]<$fee){
            	   			return $money_type_fee["all_account_scale_max"];
            	   		}else{
            	   			return $fee;
            	   		}
            	   	}
            	   break;
            	case 2:
            		//按金额
                    $user = $this->getUser($user_id);
            	   	if($user["type"]==1){
            	   		//vip
            	   		//在某个范围内返回费用
            	   		if($amount<=$money_type_fee["vip_account_all"]){
            	   			return $money_type_fee["vip_account_all_fee"];
            	   		}
            	   		
            	   		//计算出每增加一部分金额应该收取的费用
            	   		$beishu  = intval($amount/$money_type_fee["vip_account_add"]);

            	   		if($beishu>0){
            	   			$fee = $beishu*$money_type_fee["vip_account_add_fee"];
            	   		}
            	   		
            	   		//限制最高费用
            	   		
            	   		if(($money_type_fee["vip_account_all_fee"]+$fee)>=$money_type_fee["vip_account_max"]){
            	   			return $money_type_fee["vip_account_max"];
            	   		}else{
            	   			return $money_type_fee["vip_account_all_fee"]+$fee;
            	   		}
            	   		
            	   	}elseif ($user["type"]==0){
            	   		//普通会员收取的费用
            	   	    //在某个范围内返回费用
            	   		if($amount<=$money_type_fee["all_account_all"]){
            	   			return $money_type_fee["all_account_all_fee"];
            	   		}
            	   		
            	   		//计算出每增加一部分金额应该收取的费用
            	   		$beishu  = intval($amount/$money_type_fee["all_account_add"]);

            	   		if($beishu>0){
            	   			$fee = $beishu*$money_type_fee["all_account_add_fee"];
            	   		}
            	   		
            	   		//限制最高费用
            	   		if(($money_type_fee["all_account_all_fee"]+$fee)>=$money_type_fee["all_account_max"]){
            	   			return $money_type_fee["vip_account_max"];
            	   		}else{
            	   			return $money_type_fee["all_account_all_fee"]+$fee;
            	   		}
            	   		
            	   	}
            	   	break;
            	default:		   
            }
    	}
    }
    
}
?>