<?php
/*
 *  提现模型
 */
class CashModel extends CommonModel {
	
	/* 
	 * 申请提现记录
	 * @param array $data
	 * @return  string
	 */
	 
	 public function newCash($data=array()){
	 	
	    //第一步判读用户是否绑定银行信息
		$userbrand = $this->table(''.$this->tablePrefix.'user_info_bank')->where(array("user_id"=>$data["user_id"],"enable"=>1))->find();
        
		if(empty($userbrand)){
		    return array("state"=>-1,"该用户还没绑定银行卡信息，不能进行提现");
		}

		//判读提现金额是否大于零
		if($data["amount"]<=0){
		   return array("state"=>-1,"msg"=>"提现金额必须要大于零元");
		}
		
		$useraccount = $this->table(''.$this->tablePrefix.'account')->where(array("user_id"=>$data["user_id"]))->find();
		
		if($data["amount"]>$useraccount["avail"]){
			return array("state"=>-1,"msg"=>"提现金额大于可用余额");
		}
		
	    //验证交易密码
		$tender = $this->table(''.$this->tablePrefix.'user')->where(array("user_id"=>$data["user_id"]))->find();
		if(md5($data["paypassword"].C('MD5_KEY'))!=$tender["payment_password"]){
		  return array("state"=>-1,"msg"=>"支付密码不对");
		}
		
		//获取费用
		import("@.Model.AccountRecordAutoModel");
		$AccountRecordAuto = new AccountRecordAutoModel();
		$fee = $AccountRecordAuto->getAllFee("cash_success",$tender["user_id"],$data["amount"]);
		
		try{
			//开始事务
	 		$this->startTrans();
			//添加提现申请
			$items = array("ordersn" => time().rand(1000,9999).$tender["user_id"],
			               "user_id" => $tender["user_id"],
						   "status" => 0,
						   "account" => $userbrand["account"],
						   "bank" => $userbrand["bank"],
			               "bank_id" =>$userbrand["bank_id"],
			               "branch"=>$userbrand["branch"],
			               "province"=>$userbrand["province"],
			               "city"=>$userbrand["city"],
			               "district" =>$userbrand["district"],
			               "total" =>$data["amount"],
			               "credited"=>$data["amount"]-$fee,
			               "fee" =>$fee,
			               "cash_phone" =>$data["cash_phone"],
			               "cash_where" =>$data["cash_where"],
			               "addtime" => time(),
			               "addip" => getIp()
			);
			
			$id = $this->table(''.$this->tablePrefix.'account_cash')->add($items);
			
			if(empty($id)){
				throw new Exception("提交失败");
			}
			
			/*
			//处理加入资金记录的数据
	 		$account_data["ordersn"] = "cash_".$items["ordersn"];
		    $account_data["user_id"] = $items["user_id"];
		    $account_data["type_id"] = 26; //申请提现
		    $account_data["money"] = $items["total"];       //操作金额
		    $account_data["income"] = 0;               //收入
		    $account_data["expend"] = 0 ;               //支出
		    $account_data["avail_cash"] = -$items['total'];           //可提现金额
		    $account_data["avail_frost"] = 0; //不可以提现金额
		    $account_data["frost"] = $items["total"];      //冻结金额
		    $account_data["repay"] = 0;      
		    $account_data["await"] = 0;      
		    $account_data["to_userid"] = 0;
		    $account_data["account_web_status"] = 0;
		    $account_data["account_user_status"] = 0;
		    $account_data["remark"] = "申请提现{$items["total"]}元";
		    
	        import("@.Model.TenderModel");
		    $Tender = new TenderModel();
		    $record_result=$Tender->addRecord($account_data);   //添加资金记录
		    */
			
	        //处理加入资金记录的数据
			$account_data["ordersn"] = $items["ordersn"];
			$account_data["user_id"] = $tender["user_id"];
			$account_data["amount"] = $items["total"];
			$account_data["remark"] = "申请提现";
			
		    $record_result=$AccountRecordAuto->autoGetAccountDate("cash_apply",$account_data);   //添加资金记录
            if($record_result["state"]==-1){
			    	throw new ErrorException($record_result["msg"]);
			}
 		  
           
					    

			//事务提交
	 		$this->commit();
			return array("state"=>1,"msg"=>"申请成功");
		}catch (Exception $e){
			//事务回滚
	 	    $this->rollback();
	 	    return $e->getMessage();
		}
		
	 }
	 
	 /*
	  * 提现审核
	  * @param array $data
	  * @return array
	  */
	 
	 function checkStatus($data=array()){
	 	
	 	//判读之前是否已经审核过
	 	$map["id"] = $data["id"];
	 	
	 	$infos = $this->table(''.$this->tablePrefix.'customer_account_cash')->where($map)->find();
        
	 	if($infos["status"]!=0){
	 		return array("state"=>-1,"msg"=>"该提现已经进行过审核，不能重复操作");
	 	}
	 	
	 	/*
	 	if($infos["cash_where"]==3 && $data["status"]==2){
	 		return "回购不能审核失败";
	 	}*/
	 	
	 	try{
	 		//开始事务
	 		$this->startTrans();
	 		
	 	    //添加审核
	 	    $data["verify_userid"] = $_SESSION[C('USER_AUTH_KEY')];
	 	    $data["verify_time"] =  time();
	 	    $id =  $this->table(''.$this->tablePrefix.'customer_account_cash')->where($map)->save($data);
	 	    
	 		if(empty($id)){
	 			throw new Exception("审核充值信息失败");
	 		}
	 		
	 		if($data["status"]==1){
	 			

	 			
	 			
	 		    //处理加入资金记录的数据
				$account_data["ordersn"] = $infos["ordersn"];
				$account_data["cid"] = $infos["cid"];
				$account_data["amount"] = $infos['credited'];
				$account_data["remark"] = "提现审核";
				
				import("@.Model.AccountRecordModel");
			    $AccountRecordAuto = new AccountRecordAutoModel();
			    if($infos["fee"]>0){
			       $record_result=$AccountRecordAuto->autoGetAccountDate("cash",$account_data);   //添加资金记录
			    }else{
			       $record_result=$AccountRecordAuto->autoGetAccountDate("cash",$account_data,"",3);   //添加资金记录	
			    }
	            if($record_result["state"]==-1){
				    	throw new ErrorException($record_result["msg"]);
				}
			
	 		}elseif($data["status"]==2){
	 			
	 			//审核失败
	 			
	 		     //处理加入资金记录的数据
				$account_data["ordersn"] = $infos["ordersn"];
				$account_data["cid"] = $infos["cid"];
				$account_data["amount"] = $infos['total'];
				$account_data["remark"] = "提现审核";
				
				import("@.Model.AccountRecordModel");
			    $AccountRecordAuto = new AccountRecordAutoModel();
			    
			    /*
			    if($infos["cash_where"]==1){
			      $record_result=$AccountRecordAuto->autoGetAccountDate("cash_failure",$account_data,"",28);   //添加资金记录
			    }elseif ($infos["cash_where"]==6){
			      $record_result=$AccountRecordAuto->autoGetAccountDate("cash_failure",$account_data,"",77);   //添加资金记录
			    }*/
			    $record_result=$AccountRecordAuto->autoGetAccountDate("cash",$account_data,"",4);   //添加资金记录

			    if($record_result["state"]==-1){
				    	throw new ErrorException($record_result["msg"]);
				}
				
			
		     
	 		
			  
	 		}
	 		
	 		
	 	    //操作记录 --后台操作
            $action_log["cid"] = $infos["cid"];
            $action_log["name"] = $_SESSION["userName"];
            $action_log["controller"] = get_class($this);
            $action_log["method"] = ACTION_NAME;
            $action_log["url"] = getenv("HTTP_REFERER");
            $action_log["remark"] = "{$_SESSION["username"]}操作单号{$infos["ordersn"]}充值审核";
            $action_log["time"] = time();
            $action_log["ymd"] = date("Y-m-d");
            $action_log["ip"] = getIp();
            $this->table(''.$this->tablePrefix.'action_log')->add($action_log);

	 		//事务提交
	 		$this->commit();

	 	    return array("state"=>1,"msg"=>"操作成功");
	 	}catch (Exception $e){
	 	    //事务回滚
	 	    $this->rollback();
	 	    return $e->getMessage();
	 	}
	   
	 }
	 
	 /*
	  * 取消提现
	  * @param array $data
	  * @return array
	  */
     function cashCance($data=array()){
	 	
	 	//判读之前是否已经审核过
	 	$map["id"] = intval($data["id"]);
	 	
	 	if(empty($map["id"])){
	 		return array("state"=>-1,"msg"=>"参数错误");
	 	}
	 	
	 	$infos = $this->table(''.$this->tablePrefix.'account_cash')->where($map)->find();
        
	 	
	 	if($infos["user_id"]!=$data["user_id"]){
	 		return array("state"=>-1,"msg"=>"你不是申请人，不能取消提现");
	 	}
	 	
	 	if($infos["state"]!=0){
	 		return array("state"=>-1,"msg"=>"该提现已经审核过，不能重复操作");
	 	}
	 	
	 	try{
	 		//开始事务
	 		$this->startTrans();
	 		
	 	    //添加审核
	 	    $data["verify_userid"] = $_SESSION[C('USER_AUTH_KEY')];
	 	    $data["verify_time"] =  time();
	 	    $id =  $this->table(''.$this->tablePrefix.'account_cash')->where($map)->save($data);
	 	    
	 		if(empty($id)){
	 			throw new Exception("提现取消失败");
	 		}
	 		
	 		
	 		
	 		
	 	   //处理加入资金记录的数据
			$account_data["ordersn"] = $infos["ordersn"];
			$account_data["user_id"] = $infos["user_id"];
			$account_data["amount"] = $infos['total'];
			$account_data["remark"] = "用户取消提现操作";
			
			import("@.Model.AccountRecordModel");
		    $AccountRecordAuto = new AccountRecordAutoModel();
		    $record_result=$AccountRecordAuto->autoGetAccountDate("cash_apply_cancel",$account_data);   //添加资金记录
            if($record_result["state"]==-1){
			    	throw new ErrorException($record_result["msg"]);
			}
	    
	        
            
	 		//事务提交
	 		$this->commit();
	 	    return array("state"=>1,"msg"=>"操作成功");
	 	}catch (Exception $e){
	 	    //事务回滚
	 	    $this->rollback();
	 	    return $e->getMessage();
	 	}
	 }
	 
	 /*
	  * 消息提醒
	  */
	 function getRemind($infos,$status){
	 	    if($status==1){
	 	    	$title = "提现成功";
	 	    	$content="系统提示：您已经成功提现一笔{$infos['credited']}元,请核对";
	 	    	$nid="cash_success";
	 	    }else if($status==2){
	 	    	$title = "提现失败";
	 	    	$content="系统提示：你申请一笔{$infos['total']}元提现没通过审核";
	 	    	$nid="cash_false";
	 	    }
	 	    
	 	    import("@.Action.RemindAction");
            $Remind = new RemindAction();
            $touser = $this->table(''.$this->tablePrefix.'user')->where(array("user_id"=>$infos["user_id"]))->field("user_id,username,email,mobile")->find();
            $noticeData = array("tid"=>2,//默认2
    	                     "title"=>$title,
    	                     "content"=>$content,
    	                     "fuserid"=>0,
    	                     "fusername"=>"系统管理员",
    	                     "tuserid"=>$infos["user_id"],
    	                     "tusername"=>$touser["username"],
    	                     "add_time"=>date("Y-m-d H:i:s"),
    	                     
    	     );
    	 
	    	 $emailData = array("mailto"=>$touser["email"],
	    	                    "subject"=>$title."-".C("SITE_NAME"),
	    	                    "body"=>$content, 	 
	    	 );
	    	 
	    	 $mobileData =array("user_id"=>$touser["user_id"],
			              "type"=>$nid,  //类型
			              "phone"=>$touser["mobile"],
			              "status"=>0,
			              "contents"=>$content,
			              "send_code"=>"",
			              "send_status"=>0,
			              "send_time"=>time(),
			              "send_url"=>"",
			              "code"=>"",
			              "addtime"=>time(),
			              "addip"=>getIp(),
			);
			$Remind->send($noticeData,$emailData,$mobileData,$nid);
	 }
	 
	 
     /*
	  * 自动填上冻结返利金额
	  */
	 function autoAddpool($infos){
	 	       $mapcount["user_id"]=array("eq",$infos["user_id"]);
	       	   $mapcount["id"]=array("gt",$infos["id"]);
	       	   $mapcount["status"]=array("eq",0);
	 	       $list=$this->table(''.$this->tablePrefix.'account_cash')->where($mapcount)->select();
	 	       $amount  = $infos["frost_received_pool"];  
	 	       if($list){
	 	       	    foreach($list as $v)
	 	       	    {
	 	       	          if($amount<=0){
	 	       	    	  	   continue;
	 	       	    	  }
	 	       	    	  $pool = $v["total"]-$v["frost_received_pool"];
	 	       	    	  $setpool = $amount-$pool>0?$pool:$amount;
	 	       	    	  $amount = $amount-$setpool;
	 	       	    	  
	 	       	    	  //更新
	 	       	    	  if($setpool>0){
	 	       	    	    $id=$this->table(''.$this->tablePrefix.'account_cash')->where(array("id"=>$v["id"]))->setInc("frost_received_pool",$setpool);
	 	       	             if(empty($id)){
	 	       	                 throw new ErrorException("更新续投资金失败");
	 	       	             } 
	 	       	          }  	 	       	    	  
	 	       	    }
	 	      }
	 	      return  $amount; 	  
	 }
}
?>