<?php
import('@.Inter.AjaxParameter');
class CommonModel extends Model implements AjaxParameter {

	// 获取当前用户的ID
    public function getMemberId() {
        return isset($_SESSION[C('USER_AUTH_KEY')])?$_SESSION[C('USER_AUTH_KEY')]:0;
    }

   /**
     +----------------------------------------------------------
     * 根据条件禁用表数据
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param array $options 条件
     +----------------------------------------------------------
     * @return boolen
     +----------------------------------------------------------
     */
    public function forbid($options,$field='status'){

        if(FALSE === $this->where($options)->setField($field,0)){
            $this->error =  L('_OPERATION_WRONG_');
            return false;
        }else {
            return True;
        }
    }

	 /**
     +----------------------------------------------------------
     * 根据条件批准表数据
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param array $options 条件
     +----------------------------------------------------------
     * @return boolen
     +----------------------------------------------------------
     */

    public function checkPass($options,$field='status'){
        if(FALSE === $this->where($options)->setField($field,1)){
            $this->error =  L('_OPERATION_WRONG_');
            return false;
        }else {
            return True;
        }
    }


    /**
     +----------------------------------------------------------
     * 根据条件恢复表数据
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param array $options 条件
     +----------------------------------------------------------
     * @return boolen
     +----------------------------------------------------------
     */
    public function resume($options,$field='status'){
        if(FALSE === $this->where($options)->setField($field,1)){
            $this->error =  L('_OPERATION_WRONG_');
            return false;
        }else {
            return True;
        }
    }

    /**
     +----------------------------------------------------------
     * 根据条件恢复表数据
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param array $options 条件
     +----------------------------------------------------------
     * @return boolen
     +----------------------------------------------------------
     */
	 
    public function recycle($options,$field='status'){
        if(FALSE === $this->where($options)->setField($field,0)){
            $this->error =  L('_OPERATION_WRONG_');
            return false;
        }else {
            return True;
        }
    }
    
    public function recommend($options,$field='is_recommend'){
        if(FALSE === $this->where($options)->setField($field,1)){
            $this->error =  L('_OPERATION_WRONG_');
            return false;
        }else {
            return True;
        }
    }

    public function unrecommend($options,$field='is_recommend'){
        if(FALSE === $this->where($options)->setField($field,0)){
            $this->error =  L('_OPERATION_WRONG_');
            return false;
        }else {
            return True;
        }
    }

    public function getRequestParameter()
    {
		$con = array_keys($_REQUEST);
		$map = array();
		
		if(empty($this->_parameter)) 
		{
	    	$field = $this->getDBFields();
			foreach ($con as $v) {
				if( !in_array($v, $field) || is_numeric($v)) continue;
				$val = $this->getRequestValue($v, $_REQUEST[$v]);
				$map[$v] = $val;
			}
		}
		else 
		{
			$field = $this->_parameter;
			foreach ($con as $v) {
				$fieldName = $field[$v];
				if( empty($fieldName) ) continue;
				$val = $this->getRequestValue($fieldName, $_REQUEST[$v]);
				$map[$fieldName] = $val;
			}
			if(empty($map)) $map[1] = 2;
		}
    	
		return $map;
    }

    	
	private function getRequestValue($key, $val)
	{
		$key = strtoupper($key);
		if(preg_match("/^[\d,]+$/", trim($val)) && $key=='ID' ) {
			return array('in', $val);
		} else {
			return $val;
		}
	}

}
?>