<?php
/*
 *  充值模型
 */
class RechargeModel extends CommonModel {
	
	/* 
	 * 添加线下充值
	 * @param array $data
	 * @return  string
	 */
	 
	 public function newRecharge($data=array()){
	    //第一步判读用户名是否正确
	    $userinfo = $this->table(''.$this->tablePrefix.'customer')->where(array("mobile"=>$data["mobile"]))->find();
		
		if(empty($userinfo)){
		    return array("state"=>-1,"msg"=>"该用户不存在");
		}
		
		//判读金额是否大于零
		if($data["amount"]<=0){
		   return array("state"=>-1,"msg"=>"充值金额必须要大于零元");
		}
        
		//获取费用
		import("@.Model.AccountRecordAutoModel");    //引入类
		$AccountRecordAutoModel = new AccountRecordAutoModel();     //初始化该类
		
		$fee = $AccountRecordAutoModel->getFee($userinfo["user_id"],25,$data["amount"]);
		
		
		//添加充值记录
		$items = array("ordersn" => time().rand(1000,9999).$userinfo["user_id"],
		               "cid" => $userinfo["cid"],
					   "status" => 0,
					   "money" => $data["amount"],
					   "fee" => $fee,
		               "url" =>"",
		               "sign"=>"",
		               "avail"=>$data["amount"]-$fee,
		               "type"=>0,
		               "remark" => $data["remark"],
		               "addtime" => time(),
		               "addip" => getIp()
					   
		);
		
		$id = $this->table(''.$this->tablePrefix.'customer_account_recharge')->add($items);
        return $id;
	 }
	 
	 /*
	  * 审核充值
	  * @param array $data
	  * @return array
	  */
	 
	 function checkStatus($data=array()){
	 	
	 	//判读之前是否已经审核过
	 	$map["id"] = $data["id"];
	 	$infos = $this->table(''.$this->tablePrefix.'customer_account_recharge')->where($map)->find();
        
	 	if($infos["status"]!=0){
	 		return array("state"=>-1,"msg"=>"该充值已经进行过审核，不能重复操作");
	 	}
	 	
	 	try{
	 		//开始事务
	 		$this->startTrans();
	 		
	 	    //添加审核
	 	    //$data["status"]=1;
	 	    $data["verify_userid"] = $_SESSION[C('USER_AUTH_KEY')];
	 	    $data["verify_time"] =  time();
	 	    $id =  $this->table(''.$this->tablePrefix.'customer_account_recharge')->where($map)->save($data);
	 	    
	 		if(empty($id)){
	 			throw new Exception("审核充值信息失败");
	 		}
	 		
	 		if($data["status"]==1){
		 		//处理加入资金记录的数据
				$account_data["ordersn"] = $infos["ordersn"];
				$account_data["cid"] = $infos["cid"];
				$account_data["amount"] = $infos['money'];
				$account_data["remark"] = $data["verify_remark"];
				
				import("@.Model.AccountRecordAutoModel");
			    $AccountRecordAuto = new AccountRecordAutoModel();
			    $record_result=$AccountRecordAuto->autoGetAccountDate("recharge_success",$account_data,"",1);   //添加资金记录
	            if($record_result["state"]==-1){
				    	throw new ErrorException($record_result["msg"]);
				}
				
	 		}
	 		
	 		
	 	    //操作记录 --后台操作
            $action_log["user_id"] = $infos["user_id"];
            $action_log["name"] = $_SESSION["userName"];
            $action_log["controller"] = get_class($this);
            $action_log["method"] = ACTION_NAME;
            $action_log["url"] = getenv("HTTP_REFERER");
            $action_log["remark"] = "{$_SESSION["username"]}操作单号{$infos["ordersn"]}充值审核";
            $action_log["time"] = time();
            $action_log["ymd"] = date("Y-m-d");
            $action_log["ip"] = getIp();
            $this->table(''.$this->tablePrefix.'action_log')->add($action_log);

	 		
	 		//事务提交
	 		$this->commit();
	 	    return array("state"=>1,"msg"=>"操作成功");
	 	}catch (Exception $e){
	 	    //事务回滚
	 	    $this->rollback();
	 	    return array("msg"=>$e->getMessage());
	 	}
	 }
	 
	 /*
	  * 消息提醒
	  */
	 function getRemind($infos,$status,$avail){
	 	    if($status==1){
	 	    	$title = "充值成功";
	 	    	$content="系统提示：您已经成功充值一笔{$avail}元,请核对";
	 	    	$nid ="recharge_success";
	 	    }else{
	 	    	$title = "充值失败";
	 	    	$content="系统提示：您的一笔{$avail}元充值失败,请联系我们";
	 	    	$nid ="recharge_false";
	 	    }
	 	    import("@.Action.RemindAction");
            $Remind = new RemindAction();
            $touser = $this->table(''.$this->tablePrefix.'user')->where(array("user_id"=>$infos["user_id"]))->field("user_id,username,email,mobile")->find();
            $noticeData = array("tid"=>2,//默认2
    	                     "title"=>$title,
    	                     "content"=>$content,
    	                     "fuserid"=>0,
    	                     "fusername"=>"系统管理员",
    	                     "tuserid"=>$infos["user_id"],
    	                     "tusername"=>$touser["username"],
    	                     "add_time"=>date("Y-m-d H:i:s"),
    	                     
    	     );
    	 
	    	 $emailData = array("mailto"=>$touser["email"],
	    	                    "subject"=>$title."-".C("SITE_NAME"),
	    	                    "body"=>$content, 	 
	    	 );
	    	 
	    	 $mobileData =array("user_id"=>$touser["user_id"],
			              "type"=>"common",  //类型
			              "phone"=>$touser["mobile"],
			              "status"=>0,
			              "contents"=>$content,
			              "send_code"=>"",
			              "send_status"=>0,
			              "send_time"=>time(),
			              "send_url"=>"",
			              "code"=>"",
			              "addtime"=>time(),
			              "addip"=>getIp(),
			);
			$Remind->send($noticeData,$emailData,$mobileData,"recharge_success");
	 }	 
	
}
?>