<?php

class ExcelCellColor {
	protected  $_style = null;
	protected  $_font  = null;
	protected  $_color = null;
	
	function __construct($cellStyle = null) {
		$this->_style = $cellStyle;
	}
	
	function setColor($color) {
		if(!$this->isStyleInstance()) return;
		$this->_font = $this->_style->getFont();
		$this->_color = $this->_font->getColor();
		$this->_color->setRGB($color);
	}
	
	function checkStatus($row, $fieldName)
	{
		if($row['new_go'] > 0) return true;
		if(isset($row[$fieldName.'|B']) && $row[$fieldName]!=$row[$fieldName.'|B']) {
			return true;
		}
		return false;
	}
	
	function setStyleObject($cellStyle)	{
		$this->_style = $cellStyle;
	}
	
	function getNextColChar($start='A', $offset=1)
	{
		$ini = 65; //A
		$sta = 26;
		$start = strtoupper($start);
		$list = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
		
		if(empty($start)) return $offset>0&&$offset<=$sta? $list[$offset-1]: '';
		
		$char = substr($start, -1);
		$iChar  = ord($char) + $offset;
		$index = ($iChar - $ini) % $sta;
		$offset = ($iChar-$ini-$index)>0 ? ($iChar-$ini-$index)/$sta : 0;
		$res = $this->getNextColChar(substr($start, 0,-1), $offset) . $list[$index];
		
		return $res;
	}
	
	private function isStyleInstance() {
		return !empty($this->_style);
	}


}

?>
