<?php
/**
 +------------------------------------------------------------------------------
 * Filter标签库解析类
 +------------------------------------------------------------------------------
 * @category   Think
 * @package  Think
 * @subpackage  Template
 * @author    liu21st <liu21st@gmail.com>
 * @version   $Id$
 +------------------------------------------------------------------------------
 */
import('TagLib');
class TagLibFilter extends TagLib
{//类定义开始
    // 标签定义
    protected $tags   =  array(
        // 标签定义： attr 属性列表 close 是否闭合（0 或者1 默认1） alias 标签别名 level 嵌套层次
        'number'=>array('attr'=>'name,id,preValue,lastValue,selected,class,style,onchange','close'=>0),
        'string'=>array('attr'=>'name,id,preValue,lastValue,selected,class,style,onchange','close'=>0),
        'date' =>array('attr'=>'name,id,preValue,selected,class,style,onchange,unix','close'=>0),
        'select' =>array('attr'=>'name,id,srcData,selected,class,style,onchange','close'=>0),
    );
    public function _initialize() {
        $this->xml = dirname(__FILE__).'/Tags/filter.xml';
    }
    /**
     +----------------------------------------------------------
     * editor标签解析 插入可视化编辑器
     * 格式： <html:editor id="editor" name="remark" type="FCKeditor" content="{$vo.remark}" />
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param string $attr 标签属性
     +----------------------------------------------------------
     * @return string|void
     +----------------------------------------------------------
     */
    public function _number($attr)
    {
    	$tag        = $this->parseXmlAttr($attr,'number');
        $name   	= $tag['name'];
        $id			= !empty($tag['id'])? 'id="'.$tag['id'].'"': '';
        $style   	= !empty($tag['style'])? 'style="'.$tag['style'].'"':'';
        $class		= !empty($tag['class'])? 'class="'.$tag['class'] . '"': '';
        $onchange   = !empty($tag['onchange'])? ';'.$tag['onchange']:'';
        $selected   = (!empty($tag['selected']) ? $tag['selected'] : "_REQUEST");
        
        $parseStr .= "<input type='text' name='pre_$name' class='TextBox' size='10' value=\"<?php echo \${$selected}['pre_$name'];?>\" >&nbsp;&nbsp;";
        
        $parseStr .= "<select $id name=\"ope_$name\" $style $class onchange=\"javascript:$('lst_$name').style.display=this.value=='between'?'':'none';$onchange\"><option value=\"\"></option>";
        $parseStr .= "<option value='eq' <?php if(\$".$selected."['ope_$name']=='eq') echo 'selected';?>".
        			 "> = </option><option value='gt' <?php if(\$".$selected."['ope_$name']=='gt') echo 'selected';?>".
        			 "> > </option><option value='lt' <?php if(\$".$selected."['ope_$name']=='lt') echo 'selected';?>".
        			"> < </option><option value='elt' <?php if(\$".$selected."['ope_$name']=='elt') echo 'selected';?>".
        			"> <= </option><option value='egt' <?php if(\$".$selected."['ope_$name']=='egt') echo 'selected';?>".
       				"> >= </option><option value='neq' <?php if(\$".$selected."['ope_$name']=='neq') echo 'selected';?>".
               		"> != </option><option value='between'  <?php if(\$".$selected."['ope_$name']=='between') {echo 'selected';\$filterdisplay='';}else{ \$filterdisplay='none'; }?>".
        			"> between </option></select>";
        $parseStr .= "&nbsp;&nbsp;<input type='text' id='lst_$name' name='lst_$name' class='TextBox' size='10' style='display:<?php echo \$filterdisplay;?>;' value=\"<?php echo \${$selected}['lst_{$name}'];?>\">";
        return $parseStr;
    }

   public function _string($attr)
    {
        $tag        = $this->parseXmlAttr($attr,'string');
        $name   	= $tag['name'];
        $id			= !empty($tag['id'])? 'id="'.$tag['id'].'"': '';
        $style   	= !empty($tag['style'])? 'style="'.$tag['style'].'"':'';
        $class		= !empty($tag['class'])? 'class="'.$tag['class'] . '"': '';
        $onchange   = !empty($tag['onchange'])? ';'.$tag['onchange']:'';
        $selected   = (!empty($tag['selected']) ? $tag['selected'] : "_REQUEST");
        
        $parseStr .= "<input type='text' name='pre_$name' class='TextBox' size='10' value=\"<?php echo \$".$selected."['pre_$name'];?>\" >&nbsp;&nbsp;";
        
        $parseStr .= "<select $id name=\"ope_$name\" $style $class onchange=\"$onchange\"><option value=\"\"></option>";
        $parseStr .= "<option value='eq' <?php if(\$".$selected."['ope_$name']=='eq') echo 'selected';?>".
        			 "> = </option><option value='like' <?php if(\$".$selected."['ope_$name']=='like') echo 'selected';?>".
        			 "> like </option><option value='notlike' <?php if(\$".$selected."['ope_$name']=='notlike') echo 'selected';?>".
        			 ">not like</option></select>";
        return $parseStr;
    }
    
  	public function _select($attr)
    {
        $tag        = $this->parseXmlAttr($attr,'select');
        $name   	= $tag['name'];
        $srcData	= $tag['srcdata'];
        $id			= !empty($tag['id'])? 'id="'.$tag['id'].'"': '';
        $style   	= !empty($tag['style'])? 'style="'.$tag['style'].'"':'';
        $class		= !empty($tag['class'])? 'class="'.$tag['class'] . '"': '';
        $onchange   = !empty($tag['onchange'])? ';'.$tag['onchange']:'';
        $selected   = (!empty($tag['selected']) ? $tag['selected'] : "_REQUEST")."['ope_$name']";
        
        $parseStr .= "<select $id name=\"ope_$name\" $style $class onchange=\"$onchange\"><option value=\"\"></option>";
        $parseStr .= "<?php foreach (\$$srcData as \$key=>\$val) {
	        echo \"<option value='\$key' \".(\$$selected==\$key?'selected':'').\"> \$val </option>\";}?>"; 
	        
        $parseStr .= "</select>";
        return $parseStr;
    }    
    
    public function _date($attr)
    {
    	return $this->_number($attr);
    }
    
    
}//类定义结束
?>