<?php
class AccountAction extends AuthBaseAction
{
    
	public $accountRecord; //
	protected $_not_auth_action = array("rechargeView");
	
    /*
     * 资金类型
     */
    function moneyType(){
       //url参数
	   $name = getStr($_REQUEST["name"]);
	   if($name) {
	     $map["name"] = array('like',"%".$name."%");
		 $urlparams["name"] = $name;
	    } 
	  
       $Data = M("money_type a"); // 实例化adminUser数据对象
	   import('ORG.Util.Page');// 导入分页类
	   $count      = $Data->where($map)->count();// 查询满足要求的总记录数
	   
	   $Page       = new Page($count);// 实例化分页类 传入总记录数
	   $show       = $Page->show();// 分页显示输出
	   
	  
	   # // 进行分页数据查询
	   $list = $Data->where($map)->join(''.C("DB_PREFIX").'money_actiontype b on a.atypeid=b.atypeid')->field("a.*,b.title")->order('a.atypeid')->limit($Page->firstRow.','.$Page->listRows)->select();
	   
	   //传入查询条件
	   if($urlparams){
	         foreach($urlparams as $key=>$v){
			    $parameter .= "$key=".urlencode($v)."&";
			 }
	   }
	   
	   $Page->parameter= $parameter;
	   $this->assign("title","资金类型管理");
	   $this->assign('list',$list);// 赋值数据集
	   $this->assign('page',$show);// 赋值分页输出
	   $this->assign('params',$urlparams);
	   $this->display(); // 输出模板
    }
	 
	/*
	 * 添加编辑资金类型
	 */
    function addMoneyType(){
    	$typeid = intval(getStr($_GET["id"]));
    	
    	if($typeid>0){
    		//编辑
    		$Data = M("money_type");
    		$rs = $Data->find($typeid);
    		$title = "编辑资金类型";
    	}else{
    	     //添加
    		$title = "添加资金类型";
    	}
    	
    	$Actiontype = M("money_actiontype");
    	$Actiontypelist = $Actiontype->select(); //操作类型
    	$this->assign("actiontypelist",$Actiontypelist);
    	$this->assign("title",$title);
    	$this->assign("rs",$rs);
    	$AccountRecordAuto = D("AccountRecordAuto");
	    $this->assign("accountConfig",$AccountRecordAuto->AccountConfigHtml($rs["strid"]));
    	$this->display();
    }
    
   /*
    * 更新资金类型
    */
   function updateMoneyType(){
   	   //获取参数
   	   $map["type_id"] = intval(getStr($_POST["type_id"]));
   	   $data["name"] = getStr($_POST["name"]);
   	   $data["sign"] = getStr($_POST["sign"]);
   	   $data["enable"] = getStr($_POST["enable"]);
   	   $data["is_fee_type"] = getStr($_POST["is_fee_type"]);
   	   $data["type_desc"] = getStr($_POST["type_desc"]);
   	   $data["atypeid"] = getStr($_POST["atypeid"]);
   	   $data["strid"] = isset($_POST["strid"])?implode(",",getAarry($_POST["strid"])):"";
   	  
   	   //验证提示
   	   if(empty($data["name"])){
   	   	   $this->error("名称不能为空");
   	   }
   	   
   	   if(empty($data["sign"])){
   	   	   $this->error("标识不能为空");
   	   }
   	   
   	  
   	   
   	   $MoneyType = M("money_type"); //实例化数据对象

   	   if($map["type_id"]>0){
   	   	  //编辑数据
   	   	  $result = $MoneyType->where($map)->save($data);
   	   	  if($result>0){
   	   	  	  $this->success("编辑成功");
   	   	  }else{
   	   	  	  $this->error("编辑失败");
   	   	  }
   	   }else{
   	   	  if($MoneyType->add($data)){
   	   	  	  $this->success("添加成功");
   	   	  }else{
   	   	  	  $this->error("添加失败");
   	   	  }
   	   }  	   
   }
   
   /*
    * 删除资金类型
    * 
    */
    function delMoneyType(){
    	$map["type_id"] = intval(getStr($_GET["id"],'int'));
    	
    	if($map["type_id"]==0){
    		$this->error("参数错误");
    	}
    	
    	$MoneyType = M("money_type"); //实例化数据对象
    	
    	$result = $MoneyType->where($map)->delete();
    	
    	
    	
    	if($result){
    		$this->success("删除成功");
    	}else{
    		$this->error("删除失败");
    	}
    }
   
    /*
     * 资金收费明细标准
     */
    function moneyTypeFee(){
    	//url参数
	   $feename = getStr($_REQUEST["feename"]);
	 
	   if($feename) {
	     $map["a.feename"] = array('like',"%".$feename."%");
		 $urlparams["feename"] = $feename;
	    }
	   
       $Data = M("money_type_fee a"); // 实例化adminUser数据对象
	   import('ORG.Util.Page');// 导入分页类
	   $count      = $Data->where($map)->count();// 查询满足要求的总记录数
	   
	   $Page       = new Page($count);// 实例化分页类 传入总记录数
	   $show       = $Page->show();// 分页显示输出
	   
	   # // 进行分页数据查询
	   $list = $Data->where($map)->join(''.C("DB_PREFIX").'money_type b on a.type_id=b.type_id')->field("a.*,b.name")->order('a.id')->limit($Page->firstRow.','.$Page->listRows)->select();
	   //传入查询条件
	   if($urlparams){
	         foreach($urlparams as $key=>$v){
			    $parameter .= "$key=".urlencode($v)."&";
			 }
	   }
	   
	   
	   $Page->parameter= $parameter;
	   $this->assign("title","资金费用收费标准管理");
	   $this->assign('list',$list);// 赋值数据集
	   $this->assign('page',$show);// 赋值分页输出
	   $this->assign('params',$urlparams);
	   $this->display(); // 输出模板
    }
    
    
    /*
     *  添加编辑资金收费明细标准
     */
    function addMoneyTypeFee(){
    	$map["id"] = intval(getStr($_GET["id"]));
    	
    	if($map["id"]>0){
    		//编辑
    		$Data = M("money_type_fee"); //实例化数据对象
    		$rs = $Data->find($map["id"]);
    		$title = "编辑资金收费标准";
    	}else{
    		$title = "添加资金收费标准";
    	}
    	
    	//资金类型
    	$moneyType = M("money_type a");
    	$leftjoin = array(''.C("DB_PREFIX").'money_actiontype b on a.atypeid=b.atypeid');
    	$typelist = $moneyType->where("b.type_fee=1 and a.is_fee_type=1")->join($leftjoin)->field("a.*")->order("type_id")->select();
    	
    	
    	$this->assign("typelist",$typelist);
    	$this->assign("title",$title);
    	$this->assign("rs",$rs);
    	$this->display();
    }
    
    /*
     * 更新资金收费标准
     */
    
    function updateMoneyTypeFee(){
    	//参数获取
    	$map["id"] = intval(getStr($_POST["id"]));
    	$data["feename"] = getStr($_POST["feename"]);
    	$data["sign"] = getStr($_POST["sign"]);
    	$data["type_id"] = getStr($_POST["type_id"]);
    	$data["sorder"] = getStr($_POST["sorder"]);
    	$data["enable"] = getStr($_POST["enable"]);
    	$data["vip_account_scale_max"] = getStr($_POST["vip_account_scale_max"]);
    	$data["all_account_scale_max"] = getStr($_POST["all_account_scale_max"]);
    	
    	$data["fee_type"] = getStr($_POST["fee_type"]); //扣费方式
    	
    	//vip
    	$data["vip_account_all"] = sprintf("%01.2f",getStr($_POST["vip_account_all"]));
    	$data["vip_account_scale"] = sprintf("%01.2f",getStr($_POST["vip_account_scale"]));
    	$data["vip_account_all_fee"] = sprintf("%01.2f",getStr($_POST["vip_account_all_fee"]));
    	$data["vip_account_add"] = sprintf("%01.2f",getStr($_POST["vip_account_add"]));
    	$data["vip_account_add_fee"] = sprintf("%01.2f",getStr($_POST["vip_account_add_fee"]));
    	$data["vip_account_max"] = sprintf("%01.2f",getStr($_POST["vip_account_max"]));
    	
    	//会员
    	$data["all_account_scale"] = sprintf("%01.2f",getStr($_POST["all_account_scale"]));
    	$data["all_account_all"] = sprintf("%01.2f",getStr($_POST["all_account_all"]));
    	$data["all_account_all_fee"] = sprintf("%01.2f",getStr($_POST["all_account_all_fee"]));
    	$data["all_account_add"] = sprintf("%01.2f",getStr($_POST["all_account_add"]));
    	$data["all_account_add_fee"] = sprintf("%01.2f",getStr($_POST["all_account_add_fee"]));
    	$data["all_account_max"] = sprintf("%01.2f",getStr($_POST["all_account_max"]));
    	
    	
    	//参数验证
        if(empty($data["feename"])){
    		$this->error("名称不能为空");
    	}
    	
        if(empty($data["sign"])){
    		$this->error("标识不能为空");
    	}
    	
        if(empty($data["type_id"])){
    		$this->error("资金类型不能为空");
    	}
    	
    	if($data["enable"]==""){
    		$this->error("选择是否启用");
    	}
    	
    	if($data["fee_type"]==""){
    		$this->error("选择扣费方式");
    	}
    	
    	$moneyTypeFee = M("money_type_fee");  //实例化数据对象
    	
    	if($map["id"]>0){
    		//编辑
    		$result = $moneyTypeFee->where($map)->save($data);
    	   
    		if($result){
    			$this->success("编辑成功");
    		}else{
    			$this->error("编辑失败");
    		}
    	}else{
    		//添加
    		$result = $moneyTypeFee->add($data);
    		if($result){
    			$this->success("添加成功");
    		}else{
    			$this->error("添加失败");
    		}
    	}

    }
    	
    /*
    * 删除资金收费标准
    * 
    */
    function delMoneyTypeFee(){
    	$map["id"] = intval(getStr($_GET["id"],'int'));
    	
    	if($map["id"]==0){
    		$this->error("参数错误");
    	}
    	
    	$MoneyTypeFee = M("money_type_fee"); //实例化数据对象
    	
    	$result = $MoneyTypeFee->where($map)->delete();
    	
    	
    	
    	if($result){
    		$this->success("删除成功");
    	}else{
    		$this->error("删除失败");
    	}
    }
    
    
    /*
     * 资金记录
     * 
     */
    function accountRecord(){
	        //url参数
		   $realname = getStr(trim($_REQUEST["realname"]));  //用户名
		   if($realname) {
		     $map["b.realname"] = $realname;
			 $urlparams["realname"] = $realname;
		    }
		    
           $mobile = getStr(trim($_REQUEST["mobile"]));  //手机
		   if($mobile) {
		     $map["b.mobile"] = $mobile;
			 $urlparams["mobile"] = $mobile;
		    }
		    
           $type_id = getStr($_REQUEST["type_id"]);  //资金类型
		   if($type_id) {
		     $map["c.type_id"] = array('eq',$type_id);
			 $urlparams["type_id"] = $type_id;
		    }
		    
           $time1= strtotime(getStr($_REQUEST["time1"]));  //开始查询时间
           
		   if($time1) {
		     $map["a.addtime"] = array('gt',$time1);
			 $urlparams["time1"] = getStr($_REQUEST["time1"]);
		    }
		    
           $time2= strtotime(getStr($_REQUEST["time2"]));  //结束查询时间
           
		   if($time2) {
		     $map["_string"] = "a.addtime<=$time2+86400";
			 $urlparams["time2"] = getStr($_REQUEST["time2"]);     
		    }
		    

	       $Data = M("customer_account_record a"); // 实例化adminUser数据对象
		   import('ORG.Util.Page');// 导入分页类
		   
		   $leftjoin = array(''.C("DB_PREFIX").'customer b on a.cid=b.cid',''.C("DB_PREFIX").'money_type c on a.type_id=c.type_id');
		   $count      = $Data->where($map)->join($leftjoin)->count();// 查询满足要求的总记录数
		   
		   $Page       = new Page($count);// 实例化分页类 传入总记录数

 
		   # // 进行分页数据查询
		   $list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,b.mobile,c.name")->order('a.id desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		   
           if(getStr($_REQUEST["t"])){
           	  //导出excel 
           	  if(getStr($_REQUEST["t"])==2) $list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,c.name")->order('a.id asc')->select();
           	  $this->_A("Outexcel")->recordList($list);
           }
		   //$this->accountRecord = $Data->getLastSql();
		   
		   //传入查询条件
		   if($urlparams){
		         foreach($urlparams as $key=>$v){
				    $parameter .= "$key=".urlencode($v)."&";
				 }
		   }
		   
		   $show       = $Page->show();// 分页显示输出
		   
		   //资金类型
		   $Account = D("Account");  //实例化资金模式
		   
		   $moneyType = $Account->getMoneyTypeTree($type_id);
		   
		    
		   $Page->parameter= $parameter;
		   $this->assign("title","资金记录管理");
		   $this->assign('list',$list);// 赋值数据集
		   $this->assign('page',$show);// 赋值分页输出
		   $this->assign('params',$urlparams);
		   $this->assign('moneyType',$moneyType);
		   $this->assign('parameter',$parameter);
		   $this->assign('url',$parameter."p=".$_REQUEST["p"]);
		   
		   
		   $this->display(); // 输出模板
    }
    
    /*
     * 用户费用
     */
    function accountUser(){
    	   //url参数
		   $username = getStr($_REQUEST["username"]);  //用户名
		   if($username) {
		     $map["b.username"] = array('like',"%".$username."%");
			 $urlparams["username"] = $username;
		    }
		    
           $type_id = getStr($_REQUEST["type_id"]);  //资金类型
		   if($type_id) {
		     $map["c.type_id"] = array('eq',$type_id);
			 $urlparams["type_id"] = $type_id;
		    }
		    
           $time1= strtotime(getStr($_REQUEST["time1"]));  //开始查询时间
           
		   if($time1) {
		     $map["a.addtime"] = array('gt',$time1);
			 $urlparams["time1"] = $_REQUEST["time1"];
		    }
		    
           $time2= strtotime(getStr($_REQUEST["time2"]));  //结束查询时间
           
		   if($time2) {
		     $map["_string"] = "a.addtime<=$time2+86400";
			 $urlparams["time2"] = $_REQUEST["time2"];     
		    }
		    

	       $Data = M("account_users a"); // 实例化adminUser数据对象
		   import('ORG.Util.Page');// 导入分页类
		   
		   $leftjoin = array(''.C("DB_PREFIX").'user b on a.user_id=b.user_id',''.C("DB_PREFIX").'money_type c on a.type_id=c.type_id');
		   $count      = $Data->where($map)->join($leftjoin)->count();// 查询满足要求的总记录数
		   
		   $Page       = new Page($count);// 实例化分页类 传入总记录数

 
		   # // 进行分页数据查询
		   $list = $Data->where($map)->join($leftjoin)->field("a.*,b.username,c.name")->order('a.id desc')->limit($Page->firstRow.','.$Page->listRows)->select();
           
		   if($_REQUEST["t"]){
           	  //导出excel 
           	  if($_REQUEST["t"]==2) $list = $Data->where($map)->join($leftjoin)->field("a.*,b.username,c.name")->order('a.id desc')->select();
           	  $this->_A("Outexcel")->accountUser($list);
           }
		  
		   //传入查询条件
		   if($urlparams){
		         foreach($urlparams as $key=>$v){
				    $parameter .= "$key=".urlencode($v)."&";
				 }
		   }
		   
		   $show       = $Page->show();// 分页显示输出
		   
		   //资金类型
		   $Account = D("Account");  //实例化资金模式
		   
		   $moneyType = $Account->getMoneyTypeTree($type_id,1);
		   
		    
		   $Page->parameter= $parameter;
		   $this->assign("title","用户费用管理");
		   $this->assign('list',$list);// 赋值数据集
		   $this->assign('page',$show);// 赋值分页输出
		   $this->assign('params',$urlparams);
		   $this->assign('moneyType',$moneyType);
		   $this->assign('url',$parameter."p=".$_REQUEST["p"]);
		   $this->display(); // 输出模板
    }
    
    
    
  
    /*
     * 添加充值
     */
    public function addRecharge(){
    	$this->assign("title","添加充值");
    	$this->display();
    }
    
    /*
     * 更新充值
     */
    public function updateRecharge(){
    	$data["mobile"]  = getStr($_POST["mobile"]);
    	$data["amount"]= getStr($_POST["amount"],float);
        $data["remark"] = getStr($_POST["remark"]);
        
        
    	if(empty($data["mobile"])||empty($data["amount"])){
        	$this->error("手机号码和金额都不能为空");
        }
        

    	
        $recharge = D("Recharge"); //实例化充值模型对象
        $id = $recharge->newRecharge($data);
        if($id){
        	$this->success("添加成功");
        }else{
        	$this->error("添加失败");
        }
    }

    /*
     *  充值管理
     */
    function accountRecharge(){
    	   //url参数
		   $realname = getStr($_REQUEST["realname"]);  //用户名
		   if($realname) {
		     $map["b.realname"] = array('eq',$realname);
			 $urlparams["realname"] = $realname;
		    }
		    
           $mobile = getStr($_REQUEST["mobile"]);  //用户名
		   if($mobile) {
		     $map["b.mobile"] = array('eq',$mobile);
			 $urlparams["mobile"] = $mobile;
		    }
		    
           $ordersn = getStr($_REQUEST["ordersn"]);  //交易号
		   if($ordersn) {
		     $map["a.ordersn"] = array('like',"%".$ordersn."%");
			 $urlparams["ordersn"] = $ordersn;
		    }
		    
		    
           $status = getStr($_REQUEST["status"]);  //审核状态
		   if($status!="") {
		     $map["a.status"] = array('eq',$status);
			 $urlparams["status"] = $status;
		    }
		   
           $type = getStr($_REQUEST["type"]);  //充值类型
           
		   if($type!="") {
		     $map["a.type"] = array('eq',$type);
			 $urlparams["type"] = $type;
		    }

		    
           $time1= strtotime(getStr($_REQUEST["time1"]));  //开始查询时间
           
		   if($time1) {
		     $map["a.addtime"] = array('gt',$time1);
			 $urlparams["time1"] = getStr($_REQUEST["time1"]);
		    }
		    
           $time2= strtotime(getStr($_REQUEST["time2"]));  //结束查询时间
           
		   if($time2) {
		     $map["_string"] = "a.addtime<=$time2+86400";
			 $urlparams["time2"] = getStr($_REQUEST["time2"]);     
		    }
		    

	       $Data = M("customer_account_recharge a"); // 实例化account_web数据对象
		   import('ORG.Util.Page');// 导入分页类
		   
		   $leftjoin = array(''.C("DB_PREFIX").'customer b on a.cid=b.cid');
		   $count      = $Data->where($map)->join($leftjoin)->count();// 查询满足要求的总记录数
		   
		   $Page       = new Page($count);// 实例化分页类 传入总记录数
		   
           
           
		   # // 进行分页数据查询
		   $list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,b.mobile")->order('a.status=0 desc,a.id desc')->limit($Page->firstRow.','.$Page->listRows)->select();

		   if(getStr($_REQUEST["t"])){
           	  //导出excel 
           	  if(getStr($_REQUEST["t"])==2) $list = $Data->where($map)->join($leftjoin)->field("a.*,b.username,c.payment_name,d.realname")->order('a.status=0 desc,a.id desc')->select();
           	  $this->_A("Outexcel")->rechargeList($list);
           }
		   
		   //传入查询条件
		   if($urlparams){
		         foreach($urlparams as $key=>$v){
				    $parameter .= "$key=".urlencode($v)."&";
				 }
		   }
		   
		   $show       = $Page->show();// 分页显示输出
		   
		  
		   $Page->parameter= $parameter;
		   $this->assign("title","充值管理");
		   $this->assign('list',$list);// 赋值数据集
		   $this->assign('page',$show);// 赋值分页输出
		   $this->assign('params',$urlparams);
		   $this->assign('url',$parameter."p=".$_REQUEST["p"]);
		  
		   $this->display(); // 输出模板
    }
    
    /*
     * 充值查看
     * 
     */
    public function rechargeView(){
    	$id = intval(getStr($_GET["id"]));
    	
    	if($id<=0){
    		$this->error("参数错误");
    	}
    	
    	$data = M("customer_account_recharge a");  //实例化account_recharge数据对象
    	$leftjoin = array(''.C("DB_PREFIX").'customer b on a.cid=b.cid',''.C("DB_PREFIX").'admin_user d on a.verify_userid=d.user_id');
        $rs = $data->where(array("id"=>$id))->join($leftjoin)->field("a.*,b.realname,d.username as adminname")->find();
        
        
        $this->assign("infos",$rs);
        $this->assign("title","查看充值信息");
        $this->display();
    }
    
    /*
     * 审核充值
     * 
     */
    public function checkRecharge(){
    	//获取参数
    	$data["id"] = getStr($_POST["id"]);
    	$data["avail"] = getStr($_POST["avail"]);
    	$data["status"] = getStr($_POST["status"]);
    	$data["payment_status"] = getStr($_POST["status"]);
    	$data["verify_remark"] = getStr($_POST["verify_remark"]);
    	$data["verify_content"] = getStr($_POST["verify_content"]);
    	
    	if(intval($data["id"])<=0){
    		$this->error("参数错误");
    	}
    	
    	if(empty($data["status"])){
    		$this->error("状态不能为空");
    	}
    	
    	if($data["status"]==1 && $data["avail"]==0){
    		$this->error("实际到账金额不能为零");
    	}
    	
    	$data["avail"] = $data["status"]==2?0:$data["avail"];
    	
    	$recharge = D("Recharge"); //实例化充值模型对象
      
    	$rs = $recharge->checkStatus($data);
    	
    	if($rs["state"]==1){
    		$this->success($rs["msg"]);
    	}else{
    		$this->error($rs["msg"]);
    	}
    	
    }
    /*
     * 扣除费用
     */
    function deductFee(){
    	//手动费用类型
    	$Type = M("money_type");
    	$moneyType = $Type->where(array("atypeid"=>8,"enable"=>1))->select();
    	
    	$this->assign("title","扣除费用");
    	$this->assign("moneyType",$moneyType);
    	$this->display();
    }
    
    /*
     * 提交扣除费用
     */
    function saveDeductFee(){
    	$username = getStr($_POST["username"]);
    	$type_id = getStr($_POST["type_id"]);
    	$is_new_recharge = getStr($_POST["is_new_recharge"]);
    	$amount = getStr($_POST["amount"]);
    	$remark = getStr($_POST["remark"]);
    	$checkcode = getStr($_POST["checkcode"]);
    	
    	if(empty($username)||empty($type_id)||empty($amount)||empty($checkcode)){
    		$this->error("用户名、类型、金额、验证码任何一项都不可以为空");
    	}
    	
    	//验证码是否正确
        if(md5($checkcode) != session('verify')) {
        	$this->error("验证码不正确");
        }
        
        $Type = M("money_type");
    	$moneyType = $Type->where(array("type_id"=>$type_id,"enable"=>1))->find();
        
    	$items = array("username"=>$username,
    	               "type_id"=>$type_id,
    	               "is_new_recharge"=>$is_new_recharge,
    	               "amount"=>$amount,
    	               "remark"=>$remark,
    	               "type_name"=>$moneyType["name"],
    	);
    	
        $AccountDeductFeet = D("AccountDeductFee");
        $rs = $AccountDeductFeet->addDeductFee($items);
        if($rs["state"]==1){
        	$this->success("操作成功");
        }else{
        	$this->error($rs["msg"]);
        }
    }
    
    /*
     * 手动扣费
     * 
     */
    function accountDeduct(){
	        //url参数
		   $username = getStr(trim($_REQUEST["username"]));  //用户名
		   
		   if($username) {
		     $map["b.username"] = $username;
			 $urlparams["username"] = $username;
		    }
		    
           $type_id = getStr($_REQUEST["type_id"]);  //资金类型
		   if($type_id) {
		     $map["c.type_id"] = array('eq',$type_id);
			 $urlparams["type_id"] = $type_id;
		    }
		    
           $time1= strtotime(getStr($_REQUEST["time1"]));  //开始查询时间
           
		   if($time1) {
		     $map["a.addtime"] = array('gt',$time1);
			 $urlparams["time1"] = $_REQUEST["time1"];
		    }
		    
           $time2= strtotime(getStr($_REQUEST["time2"]));  //结束查询时间
           
		   if($time2) {
		     $map["_string"] = "a.addtime<=$time2+86400";
			 $urlparams["time2"] = $_REQUEST["time2"];     
		    }
		    
         
	       $Data = M("account_koufei a"); // 实例化adminUser数据对象
		   import('ORG.Util.Page');// 导入分页类
		   
		   $leftjoin = array(''.C("DB_PREFIX").'user b on a.user_id=b.user_id',''.C("DB_PREFIX").'money_type c on a.type_id=c.type_id',''.C("DB_PREFIX").'admin_user d on a.add_user_id=d.user_id');
		   $count      = $Data->where($map)->join($leftjoin)->count();// 查询满足要求的总记录数
		   
		   $Page       = new Page($count);// 实例化分页类 传入总记录数

 
		   # // 进行分页数据查询
		   $list = $Data->where($map)->join($leftjoin)->field("a.*,b.username,c.name,d.username as adminUsername")->order('a.id desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		   $this->accountRecord = $Data->getLastSql();
		   
		   //传入查询条件
		   if($urlparams){
		         foreach($urlparams as $key=>$v){
				    $parameter .= "$key=".urlencode($v)."&";
				 }
		   }
		   
		   $show       = $Page->show();// 分页显示输出
		   

		    
		   $Page->parameter= $parameter;
		   $this->assign("title","扣费管理");
		   $this->assign('list',$list);// 赋值数据集
		   $this->assign('page',$show);// 赋值分页输出
		   $this->assign('params',$urlparams);
		  
		   $this->assign('url',$parameter."p=".$_REQUEST["p"]);
		   
		   
		   $this->display(); // 输出模板
    }
    
    /*
     * 添加支付方式
     * 
     */
     function addPayment(){
     	$payment_id = getStr($_GET["payment_id"]);
     	
     	$Data = D("Payment");
     	$paycontent = $Data->payContent();
     	$this->assign("paycontent",$paycontent);
     	
     	if($payment_id>0){
     		//编辑
     		$infos = $Data->getPayment($payment_id);
     		$title ="修改支付方式";
     		if($infos["nid"]!="offline"){
     			$pay_config = unserialize($infos['config']);
     		}
     	}else{
     	    $title = "添加支付方式";
     	}
     	
     	$this->assign("title",$title);
     	$this->assign("infos",$infos);
        $this->assign("config",$pay_config);
     	$this->display();
     }
    
	 /*
	 * ajax获取支付配置
	 */
	function getPayment(){
		$payment = getStr($_POST['payment']);
		if(empty($payment))
		{
			$this->ajaxReturn("","系统忙！",-1,"json");
		}
		$Payment = D("Payment");
     	$data = $Payment->payContent();
		if(!in_array($payment, $data['payName']))
		{
			$this->ajaxReturn("","系统忙！",-1,"json");
		}
		$data = $data['payDate'][$payment];
		$config = '<table>';
		if($payment!="offline"){
			foreach($data AS $key => $value)
			{
				$config .= "<tr><td width=80><font color=\"#FF0000\">*</font><span class='label'>";
				$config .= $data[$key]['name_chinese'];
				$config .= "</span></td>";
				$config .= "<td><input name='cfg_value[]' type='text' value='" . $data[$key]['value'] . "' /></td>";
				$config .= "</tr>";
				$config .= "<input name='cfg_name[]' type='hidden' value='" .$data[$key]['name'] . "' />";
				$config .= "<input name='cfg_name_chinese[]' type='hidden' value='" .$data[$key]['name_chinese'] . "' />";
			}
		}else{
		    $config .= "<tr><td width=80><font color=\"#FF0000\">*</font><span class='label'>";
			$config .= "银行名称";
			$config .= "</span></td>";
			$config .= "<td><input name='payment_name' type='text' value=''/></td>";
			$config .= "</tr>";
		}	
		$config .= '</table>';
		
		$this->ajaxReturn($config,"",1,"json");
	}
    
	/*
	 * 更新支付方式
	 */
	function updatePayment(){
		$payment_id = getStr($_POST["payment_id"]);
		$items["payment_code"] = getStr($_POST["payment_code"]);
		$items["enable"] = getStr($_POST["enable"]);
		$items["show_order"] = getStr($_POST["show_order"]);
		$items["description"] = getStr($_POST["description"]);
		$items["logo"] = getStr($_POST["img_url"]);
		$items["payment_name"] = getStr($_POST["payment_name"]);
		
		
		
	    //配置序列化
	    if($items["payment_code"]!="offline"){
	    	if(empty($_POST['cfg_value']))
			{
				  $this->error("请输入支付配置错误");
			}
			$configArr = array();
			foreach($_POST['cfg_value'] as $key => $val)
			{
				if(empty($_POST['cfg_value']))
				{
					return $this->error("请输入支付配置错误");
				}
				$configArr[$key] = array("name" => $_POST['cfg_name'][$key],"value"=>$val, 'name_chinese' => $_POST['cfg_name_chinese'][$key]);
			}			
			$items['config'] = serialize($configArr);
			
			$Payment = D("Payment"); //实例化对象
     	    $paycontent = $Payment->payContent();
            $items["payment_name"]=array_keys($paycontent["payName"],$items["payment_code"]);
            $items["payment_name"]=$items["payment_name"][0];
	    }
	    
	    $Data = M("payment");
	    if($payment_id>0){
	    	//编辑
	    	$resulst = $Data->where(array("payment_id"=>$payment_id))->save($items);
	    	
	    	if($resulst){
	    		$this->success("编辑成功");
	    	}else{
	    		$this->error("编辑失败");
	    	}
	    }else{
	        $resulst = $Data->add($items);
	    	if($resulst){
	    		$this->success("添加成功");
	    	}else{
	    		$this->error("添加失败");
	    	}
	    }
	}
	
	
    /*
     *  支付管理
     */
    function payment(){

	       $Data = M("payment"); // 实例化account_web数据对象
		   import('ORG.Util.Page');// 导入分页类

		   $count      = $Data->where()->count();// 查询满足要求的总记录数
		   
		   $Page       = new Page($count);// 实例化分页类 传入总记录数

 
		   # // 进行分页数据查询
		   $list = $Data->where($map)->order('show_order desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		  
		   //传入查询条件
		   if($urlparams){
		         foreach($urlparams as $key=>$v){
				    $parameter .= "$key=".urlencode($v)."&";
				 }
		   }
		   
		   $show       = $Page->show();// 分页显示输出
		   
		  
		   $Page->parameter= $parameter;
		   $this->assign("title","支付管理");
		   $this->assign('list',$list);// 赋值数据集
		   $this->assign('page',$show);// 赋值分页输出
		   $this->assign('params',$urlparams);
		   $this->assign('imgsite',C('SITE_IMG'));
		   $this->display(); // 输出模板
    }

    
   /*
    * 删除支付方式
    * 
    */
    function delPayment(){
    	$map["payment_id"] = intval(getStr($_GET["id"],'int'));
    	
    	if($map["payment_id"]==0){
    		$this->error("参数错误");
    	}
    	
    	$Data= M("payment"); //实例化数据对象
    	
    	$result = $Data->where($map)->delete();

    	
    	if($result){
    		$this->success("删除成功");
    	}else{
    		$this->error("删除失败");
    	}
    }  
    
   /*
    * 银行账号管理
    * 
    */
	function accountBank(){
		//查询	
		$realname = getStr($_REQUEST["realname"]);  //用户名
		if($realname) {
		 $map["b.realname"] = array('like',"%".$realname."%");
		 $urlparams["realname"] = $realname;
		}

		$mobile = getStr($_REQUEST["mobile"]);  //审核状态
		if($mobile) {
		 $map["b.mobile"] = array('eq',$mobile);
		 $urlparams["mobile"] = $mobile;
		}

		$Data = M("customer_bank a"); // 实例化adminUser数据对象
		import('ORG.Util.Page');// 导入分页类

		$leftjoin = array(''.C("DB_PREFIX").'customer b on a.cid=b.cid');
		$count      = $Data->where($map)->join($leftjoin)->count();// 查询满足要求的总记录数

		$Page       = new Page($count);// 实例化分页类 传入总记录数

		# // 进行分页数据查询
		$list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,b.mobile")->order('a.bank_id desc')->limit($Page->firstRow.','.$Page->listRows)->select();

		

		//传入查询条件
		if($urlparams){
			 foreach($urlparams as $key=>$v){
				$parameter .= "$key=".urlencode($v)."&";
			 }
		}

		$show       = $Page->show();// 分页显示输出

		$Page->parameter= $parameter;
		$this->assign('params',$urlparams);
		$this->assign('list',$list);
		$this->assign('page',$show);// 赋值分页输出
		$this->display();
	}
   /*
    * 银行账号管理
    * 
    */
    function accountBank_edit(){
	//print_r($_GET);
		$id = getStr($_GET['id']);
		$user_info_bank = M("user_info_bank");
		$info_result = $user_info_bank->where("bank_id=".$id)->find();
		$userid = $info_result['user_id'];
		//获取用户名
		$user = M("user");
		$result = $user->where("user_id=".$userid)->find();
		$username = $result['username'];
		//获取真实姓名
		$user_approve_realname = M("user_approve_realname");
		$realname_result = $user_approve_realname->where("user_id=".$userid)->find();
		$realname = $realname_result['realname'];

		$this->assign('rs',$info_result);
		$this->assign('realname',$realname);
		$this->assign('username',$username);
		$this->display();
	}
   /*
    * 更新银行账号信息
    * 
    */
	function updateBank(){
		$id = getStr($_POST['submit']);
		$data = array(
			'bank' => getStr($_POST['bank']),
			'province' => getStr($_POST['province']),
			'city' => getStr($_POST['city']),
			'town' => getStr($_POST['town']),
			'branch' => getStr($_POST['branch']),
			'account' => enCryptksd(getStr($_POST['account']))
		);
		//print_r($data);
		$user_info_bank = M("user_info_bank"); // 实例化数据库表
		//更新银行信息
		$result = $user_info_bank->where("bank_id=".$id)->save($data);
		
		if($result){
			$this->success("编辑成功");
		}else{
			$this->error("编辑失败");
		}
		
	}
	
	
	/*
	 * 账号管理
	 */
    function accountList(){
    	
	        //url参数
		   $realname = getStr(trim($_REQUEST["realname"]));  //用户名
		   
		   if($realname) {
		     $map["b.realname"] = array('like',"%".$realname."%");
			 $urlparams["realname"] = $realname;
		    }

	       $Data = M("customer_account a"); // 实例化account数据对象
		   import('ORG.Util.Page');// 导入分页类
		   
		   $leftjoin = array(''.C("DB_PREFIX").'customer b on a.cid=b.cid');
		   $count      = $Data->where($map)->join($leftjoin)->count();// 查询满足要求的总记录数
		   
		   $Page       = new Page($count);// 实例化分页类 传入总记录数

 
		   # // 进行分页数据查询
		   $list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,b.mobile")->order('a.id desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		    
           if($_REQUEST["t"]){
           	  //导出excel 
           	  if($_REQUEST["t"]==2) $list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,b.mobile")->order("a.id desc")->select();
			  $this->_A("Outexcel")->accountList($list);
           }

		   //传入查询条件
		   if($urlparams){
		         foreach($urlparams as $key=>$v){
				    $parameter .= "$key=".urlencode($v)."&";
				 }
		   }
		   
		   $show       = $Page->show();// 分页显示输出
		   
		   $Page->parameter= $parameter;
		   $this->assign("title","资金账户管理");
		   $this->assign('list',$list);// 赋值数据集
		   $this->assign('page',$show);// 赋值分页输出
		   $this->assign('params',$urlparams);
		   $this->assign('url',$parameter."p=".$_REQUEST["p"]);
		   $this->display(); // 输出模板
    }
	
	/*
	 * 充值批量审核失败
	 */
    function rechargeBatchVerify(){

		$list = explode(",",getStr($_POST['rechargeverifyID']));
        $error = '';
		
		foreach($list as $key => $v){

			$ACCOUNT_RECHARGE = M("account_recharge");
			
			$result = $ACCOUNT_RECHARGE->where(array("id"=>$v))->find();
			if($result==false){
				$error .= $commonstr.$result['ordersn'];
				$commonstr =",";
				continue;
			}
			if($result['status']!=0){
				$error .= $commonstr.$result['ordersn'];
				$commonstr =",";
				continue;
			}
			if($result['type']!=1){
				$error .= $commonstr.$result['ordersn'];
				$commonstr =",";
				continue;
			}
			if((time()-3600)<=$result['addtime']){
				$error .= $commonstr.$result['ordersn'];
				$commonstr =",";
				continue;
			}
			$data = array(
				"status" => 2,
				"payment_status" => 2,
				"verify_userid" => $_SESSION['user_id'],
				"verify_time" => time(),
				"verify_remark" => '充值失败'
			);
			
			$rechargeVerifyResult = $ACCOUNT_RECHARGE->where(array("id"=>$v))->save($data);
			
		}
		
		if(!empty($error)){
			$msg = "其中交易号:".$error."审核操作失败";
		}
		//Log::write("错误".$msg);
		if($rechargeVerifyResult){
			$this->ajaxReturn("","审核操作成功!".$msg,1,"json");
		}else{
			$this->ajaxReturn("","审核操作失败!",-1,"json");
		}
	}
	
 }

    