<?php
abstract class BaseAction extends Action
{
	//分组名
	protected $_group_name = '';
		
	//错误信息
	protected $_error_array = array();
		
	//Model 名称
	protected $_model_name = '';
	
	//当前的数据库模型对象
	protected $_CUR_MODEL = null;
	
	/**
	 * @return boolean false
	 * */
	function setError($str)
	{
		if(is_array($str)) {
			$this->_error_array = array_merge($str, $this->_error_array);
		} else {
			$this->_error_array[] = $str;
		}
		$this->_error_array = array_unique($this->_error_array);
		
		return false;
	}
	
	/**
	 * 提取错误信息
	 * @param $isLog boolean 当处于调试模式时是否要将错误信息写入日志，默认值：true
	 * @return array
	 * */
	function getError($isLog = true)
	{
		if($isLog && C('APP_DEBUG') && !empty($this->_error_array)) Log::write(print_r($this->_error_array, true));
		return $this->_error_array;
	}
	
	/**
	 * 提取错误字符串
	 * */
	function getErrorString($arr = array(), $isBegin=true)
	{
		static $cnt = 0;
		if($isBegin && empty($arr)) $arr=$this->_error_array;
		if(empty($arr)) return '';
		$str = '';
		foreach($arr as $k=>$v) {
			if(is_array($v)) $str .= $this->getErrorString($v, false);
			elseif(!empty($v)) $str .= '['.(++$cnt).']: '.$v;
		}
		return $str;
	}
	
	/**
	 * 取跟当前Action相关的Model名称
	 * @return string
	 * */
	function getModelName()
	{
		$name = $this->_model_name;
		empty($name) && $name = $this->getActionName();
		return $name;
	}
	
	/**
	 * 获得当前模块的数据库类型对象
	 * @return object#Model
	 * */
	function getMainModel()
	{
		if(empty($this->_CUR_MODEL)) {
			$name = $this->getModelName();
			$this->_CUR_MODEL = $this->_D($name);
		}
		return $this->_CUR_MODEL;
	}
		
	protected function _D($name)
	{
		!empty($this->_group_name) && $name = $this->_group_name.'/'.$name;
		$obj = D($name);
		empty($obj) && $obj=M($name);
		return $obj;
	}
	
	protected function _A($name)
	{
		!empty($this->_group_name) && $name = $this->_group_name .'/'.$name;
		return A($name);
	}
	
	/**
	 * 读取 Relation 目录下的数据模型
	 * */
	protected function _R($name)
	{
		return D("Relation/{$name}Relation");
	}
	
	/**
	 * 读取 View 目录下的数据模型
	 * */
	protected function _V($name)
	{
		return D("View/{$name}View");
	}
	
    /**
     * 将匿名函数转换为create_function 方式
     * @param $str 格式必须以 function([参数]){}方式的字符，参数列表不允许有注释和换行
     * @return string 生成过程发生错误时返回空字符串
     * */
    protected function _anon($str)
    {
    	if(phpversion() >= '5.3') {
    		eval('$fun='.$str.';');
    		return $fun;
    	}
    	
    	$str = trim($str);
    	$cOffset = strpos($str,'{', 10); //偏移量为 function() 最基本的10个字符
    	if(!$cOffset) return '';
    	$code = substr($str, $cOffset+1); //取得代码段, 加 1 是为了把这段字符串的 { 字符去掉
    	$code = preg_replace("/\};*$/", '', trim($code));
    	if(empty($code)) return '';
    	
    	$begin = 8;
    	$len = $cOffset - $begin - 1;
     	$args = trim(substr($str, $begin, $len)); //8 截取function这8个字符之后的所有字符
   		$args = substr($args, 1); 			//去掉 开头的 ( 字符
   		$args = trim(substr($args, 0, -1)); //去掉末尾的 ) 字符
   		if($args && substr($args, 0,1)!='$') { //如果第一个字符不是 $ ，即非法
   			return '';
   		}
    	
   		$fun = create_function($args, $code);
   		return $fun;
     }
}
?>