<?php
//提现模型
class CashAction extends AuthBaseAction
{
	protected $_not_auth_action = array("cashView");
   
 /*
	 * 申请提现
	 */
  public function cashApply(){
		$this->assign("title","申请提现");
		$this->display();
	}
	
	/*
	 * 提交申请
	 */
	function cashActapply(){
		$mobile = getStr(I("mobile"));
		$amount = getStr(I("amount"));
		$Data = M("customer a");
        $leftjoin = array(''.C("DB_PREFIX").'customer_account b on a.cid=b.cid');
        $map["a.mobile"] = $mobile;
        $customerInfo = $Data->where($map)->join($leftjoin)->field("a.*,b.avail")->find();
        
        if(empty($customerInfo)){
        	$this->error("该用户不存在");
        }
        
        if($amount<0){
        	$this->error("参数异常");
        }
        
        if($customerInfo["avail"]<$amount){
        	$this->error("提现金额不能大于可用金额");
        }
        
        //判断是否绑定银行卡
        $customer_bank = M("customer_bank");
        $bankInfo = $customer_bank->where(array("cid"=>$customerInfo["cid"]))->find();
        
        if(empty($bankInfo)){
        	$this->error("没有绑定银行卡不能提现");
        }
        
        $TranDb = new Model();
      	try{
      	  	 $TranDb->startTrans();
      	  	 $customer_account_cash = M("customer_account_cash");
      	  	 $item = array("cid"=>$customerInfo["cid"],
      	  	               "ordersn"=>time().rand(4,9).$customerInfo["cid"],
      	  	               "account"=>$bankInfo["account"],
      	  	               "bank"=>$bankInfo["bank"],
      	  	               "branch"=>$bankInfo["branch"],
      	  	               "province"=>$bankInfo["province"],
      	  	               "city"=>$bankInfo["city"],
      	  	               "town"=>$bankInfo["town"],
      	  	               "total"=>$amount,
      	  	               "credited"=>$amount,
      	  	               "fee"=>0,
      	  	               "cash_phone"=>$customerInfo["mobile"],
      	  	               "cash_where"=>1,
      	  	               "addtime"=>time(),
      	  	               "addip"=>getIp()
      	  	 );
      	  	 
      	  	 $id = $customer_account_cash->add($item);
      	  	 if(empty($id)){
      	  	 	 throw new ErrorException("插入提现记录失败");
      	  	 }
      	  	  
      	  	 //资金变化
      		  import("@.Model.AccountRecordAutoModel");
		      $AccountRecordAuto = new AccountRecordAutoModel();
			  $account_data["ordersn"] = "_".$id."_".$customerInfo["cid"]."_";
			  $account_data["cid"] = $customerInfo["cid"];
			  $account_data["amount"] =  $item["credited"];
			  $account_data["remark"] = "申请提现，冻结".$item["credited"]."元";
			  $record_result=$AccountRecordAuto->autoGetAccountDate("cash",$account_data,"",2);
			  if($record_result["state"]==-1){
					throw new ErrorException("更新资金记录失败".$record_result["msg"]);
			  }
      	  	 
      	     $TranDb->commit();
      	}catch(Exception $e){
      	  	 $TranDb->rollback();
      	  	 $this->error($e->getMessage());
      	}
      	
        $this->success("操作成功");
	}
	
    /*
    * 提现管理
    * 
    */
    function accountCash(){
    	   //url参数
		   $realname = getStr($_REQUEST["realname"]);  //用户名
		   if($realname) {
		     $map["b.realname"] = array('eq',$realname);
			 $urlparams["realname"] = $realname;
		    }
		    
           $status = getStr($_REQUEST["status"]);  //审核状态
		   if($status!="") {
		     $map["a.status"] = array('eq',$status);
			 $urlparams["status"] = $status;
		    }
		   
		    
           $time1= strtotime(getStr($_REQUEST["time1"]));  //开始查询时间
		   if($time1) {
		     $map["a.addtime"] = array('gt',$time1);
			 $urlparams["time1"] = getStr($_REQUEST["time1"]);
		    }
		    
           $time2= strtotime(getStr($_REQUEST["time2"]));  //结束查询时间
           
		   if($time2) {
		     $map["_string"] = "a.addtime<=$time2+86400";
			 $urlparams["time2"] = getStr($_REQUEST["time2"]);     
		    }
		    
            $cashwhere= getStr($_REQUEST["cashwhere"]);
		    if($cashwhere) {
		     $map["a.cash_where"] = $cashwhere;
			 $urlparams["cashwhere"] = $cashwhere;     
		    }
		    

	       $Data = M("customer_account_cash a"); // 实例化account_web数据对象
		   import('ORG.Util.Page');// 导入分页类
		   
		   $leftjoin = array(''.C("DB_PREFIX").'customer b on a.cid=b.cid');
		   $count      = $Data->where($map)->join($leftjoin)->count();// 查询满足要求的总记录数
		   
		   $Page       = new Page($count);//实例化分页类 传入总记录数

 
		   # // 进行分页数据查询
		   $list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,b.mobile")->order('a.id desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		   
            if(getStr($_REQUEST["t"])==2){
           	  //导出excel 
           	  $list = $Data->where($map)->join($leftjoin)->field("a.*,b.realname,b.mobile")->order('a.id desc')->select();
           }
		
		   //冗余所在地
		   $region = M("region");
		   foreach($list as $key=>$v){
		   	   $regionProvince = $region->where(array("region_id"=>$v["province"]))->find();
		   	   $regionCity = $region->where(array("region_id"=>$v["city"]))->find();
		   	   $regionDistrict = $region->where(array("region_id"=>$v["town"]))->find();
		   	   $list[$key]["provinceName"] = $regionProvince["region_name"];
		   	   $list[$key]["cityName"] = $regionCity["region_name"];
		   	   $list[$key]["townName"] = $regionDistrict["region_name"];
		   }
		   
		   if(getStr($_REQUEST["t"])){
		   	   $this->_A("Outexcel")->accountCash($list);
		   }
		   
           
		  
		   //传入查询条件
		   if($urlparams){
		         foreach($urlparams as $key=>$v){
				    $parameter .= "$key=".urlencode($v)."&";
				 }
		   }
		   
		   $show       = $Page->show();// 分页显示输出
		   
		    
		   $Page->parameter= $parameter;
		   $this->assign("title","提现管理");
		   $this->assign('list',$list);// 赋值数据集
		   $this->assign('page',$show);// 赋值分页输出
		   $this->assign('params',$urlparams);
		   $this->assign('url',$parameter."p=".$_REQUEST["p"]);
		   $this->display(); // 输出模板
    }
   
    
    /*
     * 提现查看
     * 
     */
    public function cashView(){
    	$id = intval(getStr($_GET["id"]));
    	
    	if($id<=0){
    		$this->error("参数错误");
    	}
    	
    	$data = M("customer_account_cash a");  //实例化account_recharge数据对象
    	$leftjoin = array(''.C("DB_PREFIX").'customer b on a.cid=b.cid',''.C("DB_PREFIX").'admin_user d on a.verify_userid=d.user_id');
        $rs = $data->where(array("id"=>$id))->join($leftjoin)->field("a.*,b.realname,d.username as adminname")->find();
        
        
        $this->assign("infos",$rs);
        $this->assign("title","查看充值信息");
        $this->display();
    }
    
   /*
     * 审核提现
     * 
     */
    public function checkCash(){
    	//获取参数
    	$data["id"] = getStr($_POST["id"]);
    	$data["status"] = getStr($_POST["status"]);
    	$data["verify_remark"] = getStr($_POST["verify_remark"]);
    	$checkcode = getStr($_POST['checkcode']);
    	
    	if(intval($data["id"])<=0){
    		$this->error("参数错误");
    	}
    	
    	if(empty($data["status"])){
    		$this->error("状态不能为空");
    	}
    	
        if(md5($checkcode) != session('verify')) {
        	$this->error("验证码不正确");
        }
    	
    	$Cash = D("Cash"); //实例化充值模型对象
    	$rs = $Cash->checkStatus($data);
    	
    	if($rs["state"]==1){
    		$this->success($rs["msg"],"/Cash/accountCash");
    	}else{
    		$this->error($rs,"/Cash/accountCash");
    	}
    	
    }
    
    /*
     *  用户撤销申请
     *  
     */
    public function cashCance(){
    	$data["id"] = getStr($_REQUEST["id"]);
    	$data["status"] = 3;
    	$data["user_id"] =2;
    	
        $Cash = D("Cash"); //实例化充值模型对象
    	$rs = $Cash->cashCance($data);
    	
    	if($rs["state"]==1){
    		$this->success($rs["msg"]);
    	}else{
    		$this->error($rs["msg"]);
    	}
    	
    }
    
}