<?php
//导出excel
class OutexcelAction extends AuthBaseAction
{   
	
   /*
    * 导出员工信息
    * 
    */
	function employeeList($result){
		  
		   //设置标题
		        $rowVal = array(0=>'序号',1=>'员工姓名', 2=>'手机号码',3=>"邮箱",4=>"身份证号码",5=>"岗位名称",6=>"入职时间",7=>"转正时间",8=>"是否离职");
		   //设置列数据 
		       if($result){
		        	 foreach($result as $key=>$v){
		        	 	    if($v["is_quit"]==1){
		        	 	    	$str = "是";
		        	 	    }else{
		        	 	    	$str = "--";
		        	 	    }
		        	 	    $result[$key][1]=$v["realname"];
		        	 	    $result[$key][2]=$v["mobile"];
		        	 	    $result[$key][3]=$v["email"];
		        	 	    $result[$key][4]=$v["card"];
		        	 	    $result[$key][5]=$v["name"];
		        	 	    $result[$key][6]=$v["entrant_time"];
		        	 	    $result[$key][7]=$v["formal_time"];
		        	 	    $result[$key][7]=$str;
		        	 }
		       }
		       $this->commonexcel($rowVal,$result,"员工信息");
	}
	
  /*
    * 导出客户信息
    * 
    */
	function customerList($result){
		  
		   //设置标题
		        $rowVal = array(0=>'序号',1=>'客户姓名', 2=>'身份证号码',3=>"手机号码",4=>"邮箱地址",5=>"联系方式",6=>"所属员工",7=>"添加时间");
		   //设置列数据 
		       if($result){
		        	 foreach($result as $key=>$v){
		        	 	  
		        	 	    $result[$key][1]=$v["realname"];
		        	 	    $result[$key][2]=$v["card"];
		        	 	    $result[$key][3]=$v["mobile"];
		        	 	    $result[$key][4]=$v["email"];
		        	 	    $result[$key][5]=$v["address"];
		        	 	    $result[$key][6]=$v["ygRealname"];
		        	 	    $result[$key][7]=date("Y-m-d",$v["addtime"]);
		        	 }
		       }
		       $this->commonexcel($rowVal,$result,"客户信息");
	}
	
 /*
    * 导出资金记录
    * 
    */
	function recordList($result){
		  
		   //设置标题
		        $rowVal = array(0=>'序号',1=>'客户姓名', 2=>'手机号码',3=>"类型",4=>"收入",5=>"支出",6=>"余额",7=>"总资金/上次",8=>"总冻结/变化",9=>"待收",10=>"添加时间");
		   //设置列数据 
		       if($result){
		        	 foreach($result as $key=>$v){
		        	 	  
		        	 	    $result[$key][1]=$v["realname"];
		        	 	    $result[$key][2]=$v["mobile"];
		        	 	    $result[$key][3]=$v["name"];
		        	 	    $result[$key][4]=$v["income_new"];
		        	 	    $result[$key][5]=$v["expend_new"];
		        	 	    $result[$key][6]=$v["avail"];
		        	 	    $result[$key][7]=$v["totalamount"]/$v["totalamount_old"];
		        	 	    $result[$key][8]=$v["frost"]/$v["frost_new"];
		        	 	    $result[$key][9]=$v["await"];
		        	 	    $result[$key][10]=date("Y-m-d",$v["addtime"]);
		        	 }
		       }
		       $this->commonexcel($rowVal,$result,"资金记录");
	}
	
	
/*
	 * 导出充值记录
	 */
	function rechargeList($result){
	
		   //设置标题
		        $rowVal = array(0=>'序号',1=>'用户姓名',2=>"手机",3=>'交易号',4=>"类型",5=>"充值银行",6=>"充值金额",7=>"充值手续费",8=>"实际到账金额",9=>"状态",10=>"操作时间",11=>"操作ip");
		        if($result){
		        	 foreach($result as $key=>$v){
			        	    if($v["type"]==0){
					        	$str_type = "线下充值";
					        	$v["payment_name"] = $v["payment_name"]?$v["payment_name"]:"手动充值";
					        }elseif($v["type"]==1){
					        	$str_type = "网上充值";
					        }
					        
					        if($v["status"]==0){
				            	if($v["type"]==1 && $v["payment_status"]==0){
				            		$str_state = "未支付";
				            	}else{
				            		$str_state = "审核中";
				            	}
				            }elseif($v["status"]==1){
				            	$str_state = "充值成功";
				            }elseif($v["status"]==2){
				            	$str_state = "充值失败";
				            }
				            
		        	 	    $result[$key][1]=$v["realname"];
		        	 	    $result[$key][2]=$v["mobile"];
		        	 	    $result[$key][3]=" ".$v["ordersn"];
		        	 	    $result[$key][4]=$str_type;
		        	 	    $result[$key][5]=$v["payment_name"];
		        	 	    $result[$key][6]=$v["money"];
		        	 	    $result[$key][7]=$v["fee"];
		        	 	    $result[$key][8]=$v["avail"];
		        	 	    $result[$key][9]=$str_state;
		        	 	    $result[$key][10]=date("Y-m-d H:i:s",$v["addtime"]);
		        	 	    $result[$key][11]=$v["addip"];
		        	 }
		       }
		       $this->commonexcel($rowVal,$result,"充值记录");
	}
	
 /*
    * 导出 资金账号
    * 
    */
	function accountList($result){
		  
		   //设置标题
		        $rowVal = array(0=>'序号',1=>'用户姓名', 2=>'资产总额',3=>"可用金额",4=>"冻结金额",5=>"待收金额");
		   //设置列数据 
		       if($result){
		        	 foreach($result as $key=>$v){
		        	 	    $result[$key][1]=$v["realname"];
		        	 	    $result[$key][2]=$v["totalamount"];
		        	 	    $result[$key][3]=$v["avail"];
		        	 	    $result[$key][4]=$v["frost"];
		        	 	    $result[$key][5]=$v["await"];
		        	 }
		       }
		       $this->commonexcel($rowVal,$result,"资金账号管理");
	}

	
 /*
    * 导出 员工提成
    * 
    */
	function yejiList($result){
		  
		   //设置标题
		        $rowVal = array(0=>'序号',1=>'客户姓名', 2=>'手机号码',3=>"理财产品",4=>"金额",5=>"期限",6=>"所属员工",7=>"下单时间");
		   //设置列数据 
		       if($result){
		        	 foreach($result as $key=>$v){
		        	 	    $result[$key][1]=$v["realname"];
		        	 	    $result[$key][2]=$v["mobile"];
		        	 	    $result[$key][3]=$v["financial_type_name"];
		        	 	    $result[$key][4]=$v["account"];
		        	 	    $result[$key][5]=$v["unit_sort"].$v["unit"];
		        	 	    $result[$key][6]=$v["ygname"];
		        	 	    $result[$key][7]=date("Y-m-d",$v["verify_time"]);
		        	 	   
		        	 }
		       }
		       $this->commonexcel($rowVal,$result,$setTime."业绩统计");
	}
	
	
 /*
    * 导出 员工提成
    * 
    */
	function jixiaoList($result){
		  
		   //设置标题
		        $rowVal = array(0=>'序号',1=>'用户姓名', 2=>'手机号码',3=>"业绩总额",4=>"基本工资",5=>"绩效金额",6=>"提成金额",7=>"提成月份");
		   //设置列数据 
		       if($result){
		        	 foreach($result as $key=>$v){
		        	 	    $result[$key][1]=$v["realname"];
		        	 	    $result[$key][2]=$v["mobile"];
		        	 	    $result[$key][3]=$v["amount"];
		        	 	    $result[$key][4]=$v["pay"];
		        	 	    $result[$key][5]=$v["jixiao"];
		        	 	    $result[$key][6]=$v["ticheng"];
		        	 	    $result[$key][7]=$v["year"]-$v["month"];
		        	 	    $setTime = $v["year"]-$v["month"];
		        	 }
		       }
		       $this->commonexcel($rowVal,$result,$setTime."员工提成");
	}
	
	
    
    
    /*
     * 导出函数
     * param array   $rowVal  设置标题
     * param array   $result   
     * param string  $filename  导出文件名
     */
     private function commonexcel($rowVal,$result,$filename){
	            set_time_limit(0);
                //引入phpexcel类
			    Vendor('PHPExcel.PHPExcel');
		        Vendor('PHPExcel.PHPExcel.IOFactory');
		        Vendor('PHPExcel.PHPExcel.Reader.Excel5');
		        $objPHPExcel = new PHPExcel();
		        $objPHPExcel->getActiveSheet()->getDefaultColumnDimension()->setWidth(20);//设置单元格宽度
		        $objPHPExcel->getActiveSheet()->setTitle($filename."-导出记录");//设置工作簿名称
		        
		        
		      //设置标题
		        foreach($rowVal as $k=>$r){
		            $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow($k, 2)->getFont()->setBold(true);//字体加粗
		            $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow($k, 2)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);// 文字居中
		            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($k, 2, $r);
		        }
		        $date = date("Y-m-d H:i:s");
		        $objPHPExcel->getActiveSheet()->mergeCells("A1:Y1")->setCellValueByColumnAndRow(0, 1, "统计导出时间：$date")->getStyleByColumnAndRow(0,1)->getFont()->setBold(true)->getColor()->setARGB("ffff0000");
		        
		        $i=3;
		        $j=1;
		
		        foreach($result as $v){
		               
		        	foreach($rowVal as $key=>$v2){
		        		if($key==0){
		        		  $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($key,$i,$j);
		        		}else{
		        		  $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($key,$i,$v[$key]);
		        		}
		        	}
		        $i++;
		        $j++;
		        }
		        
		       $excelName = $filename.date("Y-m-d").".xls";//设置excel文件名
		       $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel,"Excel5");
		       header("Content-Type: application/force-download");
		       header("Content-Type: application/octet-stream");
		       header("Content-Type: application/download");
		       header("Content-Disposition: attachment; filename=".$excelName);
		       header("Content-Transfer-Encoding: binary");
		       header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		       header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
		       header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		       header("Pragma: no-cache");
			   $objWriter->save("php://output");
    }
}