<?php
import("ORG.Util.Date");
/**
 * 计算日期时间
 * */
class KDDatetime extends Date
{
	protected $_method = array('year', 'month', 'day', 'hour', 'minute', 'second', 'week');
	
	/**
	 * 用于计算的参考时间值
	 * @param int $current
	 * */
	function __construct($curent = '')
	{
		$curent = empty($curent) ? '' : $curent;
		parent::__construct($curent);
		$this->setCurTime($this->date)->setFormat();
	}
	
	/**
	 * 是否需要按指定的时间格式来计算，例如'Y-m-d'，则会按天的倍数来计算时间
	 * */
	function setFormat($type='Y-m-d')
	{
		$this->_format = $type;
		return $this;
	}
	
	/**
	 * 要比较的时间(被减数)
	 * @param int $int
	 * */
	function setTime($int)
	{
		$this->_time = $int;
		return $this;
	}
	
	/**
	 * 取比较值
	 * @param string $type 返回的值类别，year, month, day, hour, minute, second
	 * @param string $fun 用于计算精度的函数，默认 floor 取最小整数值, 如果不需要时请赋空字串值''
	 * @return int 返回curTime - time 的值
	 * */
	function compare($type, $fun = 'floor')
	{
		$res = $this->_formatTime($this->_cur_time) - $this->_formatTime($this->_time);
		$fun = function_exists($fun) ? $fun : '';
		
		switch (strtolower($type))
		{
			case 'year':
				$res /= 3600*24*365;
				break;
			case 'month':
				$res /= 3600*24*30;
				break;
			case 'day':
				$res /= 3600*24;
				break;
			case 'week':
				$res /= 3600*24*7;
				break;
			case 'hour':
				$res /= 3600;
				break;
			case 'minute':
				$res /= 60;
				break;
			case 'second':
				break;
			default:
				break;
		}
		$rs = $res;
		$fun && $rs = $fun(abs($res));
		
		return $res<0 ? -$rs : $rs;
	}
	
	/**
	 * 用于参考的时间(减数)
	 * @param int $intCurrent
	 * */
	function setCurTime($intCurrent)
	{
		$this->_cur_time = $intCurrent;
		return $this;
	}
	
	/**
     * 人性化的计算日期差
     * @static
     * @access public
     * @param mixed $time 要比较的时间
     * @param mixed $precision 返回的精度,从年（默认）开始，依次为1:个月，2：周，3：天，4：小时，5：分钟，6：秒
     * @return array array('res'=>秒数, 'str'=>生成的时间字符串)
     */
    public function timeDiff( $time ,$precision=false) {
        if(!is_numeric($precision) && !is_bool($precision)) {
            static $_diff = array('y'=>'年','M'=>'个月','d'=>'天','w'=>'周','s'=>'秒','h'=>'小时','m'=>'分钟');
            return ceil($this->dateDiff($time,$precision)).$_diff[$precision].'前';
        }
        $res  = $this->parse($time) - $this->date;
        $diff  = abs($res);
        static $chunks = array(array(31536000,'年'),array(2592000,'个月'),array(604800,'周'),array(86400,'天'),array(3600 ,'小时'),array(60,'分钟'),array(1,'秒'));
        $count =0;
        $since = '';
        for($i=0;$i<count($chunks);$i++) {
            if($diff>=$chunks[$i][0]) {
                $num   =  floor($diff/$chunks[$i][0]);
                $since .= sprintf('%d'.$chunks[$i][1],$num);
                $diff =  (int)($diff-$chunks[$i][0]*$num);
                $count++;
                if(!$precision || $count>=$precision) {
                    break;
                }
            }
       }
       return array('res'=>$res, 'str'=>$since);
    }
	
	/**
	 * 按照时间格式截取时间值
	 * */
	protected function _formatTime($time)
	{
		if(empty($this->_format)) return $time;
		$tmp = date($this->_format, $time);
		if(empty($tmp)) return $time;
		return strtotime($tmp);
	}
	
	function __call($method, $arg)
	{
		if(preg_match("/^compare([a-z]+)/i", $method, $arr) && in_array(strtolower($arr[1]), $this->_method) 
		   || preg_match("/^com([a-z]+)/i", $method, $arr) && in_array(strtolower($arr[1]), $this->_method)) {
			if(isset($arg[0]) ) {
				return $this->compare($arr[1], $arg[0]);
			} else {
				return $this->compare($arr[1]);
			}
		}
	}
}
?>