<?php
//自动调用扣除资金类型
class AccountRecordAutoModel extends Model {
	
	/*
	 * @params string 金额变化操作配置
	 * @return array
	 */
	function accountConfig(){	
	 return	array("1"=>array("收入","income_new",""),
		      "2"=>array("支出","expend_new",""),
		      "3"=>array("增加可提现","avail_cash_new",""),
		      "4"=>array("减少可提现","avail_cash_new","-"),
		      "5"=>array("增加不可提现","avail_frost_new",""),
		      "6"=>array("减少不可提现","avail_frost_new","-"),
		      "7"=>array("增加冻结","frost_new",""),
		      "8"=>array("减少冻结","frost_new","-"),
		      "11"=>array("增加待收","await_new",""),
		      "12"=>array("减少待收","await_new","-"),
		);
	}
	
   /*
    * 获取金额变化配置文件
    * @param string 
    * @return string
    */
	function AccountConfigHtml($strid=""){
		$html = "";
		foreach($this->accountConfig() as $key=>$v){
			if($strid){
				if(in_array($key,explode(",",$strid))){
					$checkstr = " checked='checked'";
				}else{
					$checkstr="";
				}
			}
			$html.="<input name='strid[]' type='checkbox' value='$key' $checkstr>$v[0]";
		}
		return $html;
	}
	
	
	
    /* 
     * 自动添加资金记录
     * @param string $nid  标识
     * @param array  $data 
     * @param string $type 收费明 显类型（资金，借款）
     * @param int  $type_id 可选 
     * @return string
     */
	function autoGetAccountDate($nid,$data,$type="",$type_id=""){
		if(!$nid){
			return false;
		}
				
		//操作类型		
		$map["nid"] = array("eq",$nid);
		$actionType = $this->table(''.$this->tablePrefix.'money_actiontype')->where($map)->find();
	
		//资金类型
		$map_type["atypeid"] = array("eq",$actionType["atypeid"]);
		$map_type["enable"] = array("eq",1);
		if($type_id){
		 $map_type["type_id"]= array("eq",$type_id);
		}
	    $typelist  = $this->table(''.$this->tablePrefix.'money_type')->where($map_type)->order("type_id asc")->select();
     
	    if($typelist){
		    foreach($typelist as $v){
		    	if($type==""){
		    		//资金收费标准
		    		$map_fee["type_id"]=array("eq",$v["type_id"]);
		    		//$map_fee["enable"]=array("eq",1);
		    		$infoFee= $this->table(''.$this->tablePrefix.'money_type_fee')->where($map_fee)->find();
		    		if($infoFee){
		    			if($infoFee["enable"]==0){
		    				$amount=0;
		    			}
		    			//如果存在收费标准则获取费用
		    			$amount = $this->getFee($data["cid"],$v["type_id"],$data["amount"]);
		    		}else{
		    		    $amount = $data["amount"];
		    		}
		    		
		    	}elseif($type="borrow_fee"){
		    	    //借款收费标准
		    	     	
		    	}
               
		       //获取资金变化配置
		       $accountConfig = $this->accountConfig();
		      
		       //资金数据整合
		        $account_data = array();
		       if($accountConfig){
		       	   foreach($accountConfig as $key=>$v2){
	       	             if(in_array($key,explode(",",$v["strid"]))){
	       	   	     		$amount_new = $v2[2].$amount;
	       	   	     	 }else{
	       	   	     		$amount_new = 0;
	       	   	     	 }
		       	   	     if(!$account_data["$v2[1]"]){
		       	   	      $account_data["$v2[1]"] = $amount_new;
		       	   	     }
		       	   }
		       }
		       		       
		       $account_data["ordersn"] = $v["sign"].$data["ordersn"];
			   $account_data["cid"] = $data["cid"];
			   $account_data["type_id"] = $v["type_id"]; //资金类型
			   $account_data["money"] = $amount;    //金额
               $account_data["remark"] = $data["remark"];
               
               if($amount>0){
		        $result=$this->addRecord($account_data);
               }
                
		    }
		    return $result;
	    }
		
	}
	

	
    /*  
     * 资金收费标准   --查出资金类型该收多少费用
     * @param int $userid  用户
     * @param int $type_id 资金类型
     * @param int $amount  金额
     * @return float 
     */
    
    function getFee($user_id,$type_id=0,$amount){
    	if($type_id>0){
    		$money_type_fee = $this->table(''.$this->tablePrefix.'money_type_fee')->where(array("type_id"=>$type_id,"enable"=>1))->find();
    		
    		if(empty($money_type_fee)){
                 return 0;
            }
            switch ($money_type_fee["fee_type"]){
            	case 0:
            		//免费
            		return 0;
            		break;
            	case 1:
            		//按比列
            		$user = $this->getUser($user_id);
            	   	if($user["type"]==1){
            	   		//vip
            	   		$fee = $amount*$money_type_fee["vip_account_scale"]*0.01;
            	   		//判读是否有vip最高提限制
            	   		if($money_type_fee["vip_account_scale_max"]>0 && $money_type_fee["vip_account_scale_max"]<$fee){
            	   			return $money_type_fee["vip_account_scale_max"];
            	   		}else{
            	   			return $fee;
            	   		}
            	   		
            	   	}elseif ($user["type"]==0){
            	   		//普通会员
            	   		$fee = $amount*$money_type_fee["all_account_scale"]*0.01;
            	   	    if($money_type_fee["all_account_scale_max"]>0 && $money_type_fee["vip_account_scale_max"]<$fee){
            	   			return $money_type_fee["all_account_scale_max"];
            	   		}else{
            	   			return $fee;
            	   		}
            	   	}
            	   break;
            	case 2:
            		//按金额
                    $user = $this->getUser($user_id);
            	   	if($user["type"]==1){
            	   		//vip
            	   		//在某个范围内返回费用
            	   		if($amount<=$money_type_fee["vip_account_all"]){
            	   			return $money_type_fee["vip_account_all_fee"];
            	   		}
            	   		
            	   		//计算出每增加一部分金额应该收取的费用
            	   		$beishu  = intval($amount/$money_type_fee["vip_account_add"]);

            	   		if($beishu>0){
            	   			$fee = $beishu*$money_type_fee["vip_account_add_fee"];
            	   		}
            	   		
            	   		//限制最高费用
            	   		if(($money_type_fee["vip_account_all_fee"]+$fee)>=$money_type_fee["vip_account_max"]){
            	   			return $money_type_fee["vip_account_max"];
            	   		}else{
            	   			return $money_type_fee["vip_account_all_fee"]+$fee;
            	   		}
            	   		
            	   	}elseif ($user["type"]==0){
            	   		//普通会员收取的费用
            	   	    //在某个范围内返回费用
            	   		if($amount<=$money_type_fee["all_account_all"]){
            	   			return $money_type_fee["all_account_all_fee"];
            	   		}
            	   		
            	   		//计算出每增加一部分金额应该收取的费用
            	   		$beishu  = intval($amount/$money_type_fee["all_account_add"]);

            	   		if($beishu>0){
            	   			$fee = $beishu*$money_type_fee["all_account_add_fee"];
            	   		}
            	   		
            	   		//限制最高费用
            	   		if(($money_type_fee["all_account_all_fee"]+$fee)>=$money_type_fee["all_account_max"]){
            	   			return $money_type_fee["vip_account_max"];
            	   		}else{
            	   			return $money_type_fee["all_account_all_fee"]+$fee;
            	   		}
            	   		
            	   	}
            	   	break;
            	default:		   
            }
    	}
    }

    /*
     * 获取所有费用
     * @param string $nid
     * @param int $user_id
     * @param float $amount
     * @return float
     */
    function getAllFee($nid,$user_id,$amount){
        $map["nid"] = array("eq",$nid);
		$actionType = $this->table(''.$this->tablePrefix.'money_actiontype')->where($map)->find();
		//资金类型
		$map_type["atypeid"] = array("eq",$actionType["atypeid"]);
		$map_type["enable"] = array("eq",1);
	    $typelist  = $this->table(''.$this->tablePrefix.'money_type')->where($map_type)->order("type_id asc")->select();
	    if($typelist){
	    	$allFee =0;
	    	foreach($typelist as $v){
	    		$map_fee["enable"]=array("eq",1);
	    		$map_fee["type_id"]=array("eq",$v["type_id"]);
		    	$infoFee= $this->table(''.$this->tablePrefix.'money_type_fee')->where($map_fee)->find();
		    	if($infoFee){
		    		$Fee=$this->getFee($user_id,$infoFee["type_id"],$amount);
		    	}
		       $allFee=$allFee+$Fee;	
	    	}
	    	return $allFee;
	    }else{
	    	return 0;
	    }
	    
    }

	/*
	 *  添加资金记录
	 *  @param array $data
	 *  @return array
	 */
	
	function addRecord($data=array()){
		//检查该资金记录是否已经存在
		$recordinfo = $this->table(''.$this->tablePrefix.'customer_account_record')->where(array("ordersn"=>$data["ordersn"]))->find();
		if($recordinfo){
			return array("state"=>-1,"msg"=>"该资金记录已经存在");
		}
		
		//查询原来的总资金
		$accountinfo  = $this->table(''.$this->tablePrefix.'customer_account')->where(array("cid"=>$data["cid"]))->find();
		
		if(empty($accountinfo)){
			 $items = array("cid"=>$data["cid"],
			                "totalamount" =>0,
			                "income" => 0,
			                "expend" => 0,
			                "avail"=>0,
			                "avail_cash"=>0,
			                "avail_frost"=>0,
			                "frost"=>0,
			                "await"=>0,
			 );
			 
			 $result = $this->table(''.$this->tablePrefix.'customer_account')->add($items);
			 if(!$result){
			 	return array("state"=>-1,"msg"=>"插入用户资金表失败");
			 }
			 //重新查询
		     $accountinfo  = $this->table(''.$this->tablePrefix.'customer_account')->where(array("cid"=>$data["cid"]))->find();
		}
	    $old_avail_new = $data["old_avail_new"];
		//加入用户资金主表
		$record_data = $data;
		$record_data["income_new"] = $data["income_new"];
		$record_data["income_old"] = $accountinfo["income"];
        $record_data["income"]=$record_data["income_new"]+$record_data["income_old"];
		
		$record_data["expend_new"] = $data["expend_new"];
		$record_data["expend_old"] = $accountinfo["expend"];
		$record_data["expend"] = $record_data["expend_new"]+$record_data["expend_old"];
		
		$record_data["avail_cash_new"] = $data["avail_cash_new"];
		$record_data["avail_cash_old"] = $accountinfo["avail_cash"];
		$record_data["avail_cash"] = $record_data["avail_cash_new"]+$record_data["avail_cash_old"];
		
		$record_data["avail_frost_new"] = $data["avail_frost_new"];
		$record_data["avail_frost_old"] = $accountinfo["avail_frost"];
		$record_data["avail_frost"] = $record_data["avail_frost_old"]+ $record_data["avail_frost_new"];
		
		$record_data["avail_new"] = $record_data["avail_cash_new"] +  $record_data["avail_frost_new"];
		$record_data["avail_old"] = $accountinfo["avail"];
		$record_data["avail"] = $record_data["avail_new"]+ $record_data["avail_old"];
		
		
		
		$record_data["frost_new"] = $data["frost_new"];
		$record_data["frost_old"] = $accountinfo["frost"];
		$record_data["frost"] = $record_data["frost_new"]+ $record_data["frost_old"];
		
		
		$record_data["await_new"] = $data["await_new"];
		$record_data["await_old"] = $accountinfo["await"];
		$record_data["await"] = $record_data["await_new"]+ $record_data["await_old"];
		
		$record_data["totalamount_old"] = $accountinfo["totalamount"];
		$record_data["totalamount"] = $accountinfo["totalamount"]+$record_data["avail_new"]+$record_data["frost_new"]+$record_data["await_new"];
		
		$record_data["addtime"] = time();
		$record_data["addip"] = getIp();
		
		//插入资金记录
		$record_result = $this->table(''.$this->tablePrefix.'customer_account_record')->add($record_data);
		
		if(empty($record_result)){
			return array("state"=>-1,"msg"=>"插入资金记录失败");
		}
		//更新用户账户表
		$totalamount_new = $record_data["avail_new"]+ $record_data["frost_new"] + $record_data["await_new"];
		$income_new = $record_data["income_new"];//新收入
		$expend_new = $record_data["expend_new"];
		$avail_new = $record_data["avail_new"];
		$avail_cash_new = $record_data["avail_cash_new"];
		$avail_frost_new = $record_data["avail_frost_new"];
		$frost_new = $record_data["frost_new"];
		$await_new = $record_data["await_new"];
		$daidong_amount_new = $record_data["daidong_amount_new"];
		$share_amount_new = $record_data["share_amount_new"];
		
		
		$account_item_sql='update '.$this->tablePrefix.'customer_account set ';
		$account_item_sql.= "totalamount=totalamount+$totalamount_new,income=income+$income_new,expend=expend+$expend_new,avail=avail+$avail_new,avail_cash=avail_cash+$avail_cash_new,avail_frost=avail_frost+$avail_frost_new,frost=frost+$frost_new,await = await+$await_new";
		$account_item_sql.=',updatetime='.time();
		$account_item_sql.= " where cid=$data[cid]";
	
	    if(!$this->db->execute($account_item_sql)){
	    	
			return array("state"=>-1,"msg"=>"更新用户主表失败");
		}
	
		 return array("state"=>1,"msg"=>"操作成功","ordersn"=>$data["ordersn"]);	

	}
	
	/*
	 * 获取用户账号信息
	 * @param int $userid
	 * @return array
	 */
    function getAccout($userid){
    	if(intval($userid)>0){
    		$rs=$this->table(''.$this->tablePrefix.'account')->where(array("user_id"=>$userid))->find();
    		return $rs;
    	}
    }
    
    /*
     * 获取用户主表信息
     * @param int $userid
     * @return array
     */
    function getUser($userid){
    	if(intval($userid)>0){
    		$rs=$this->table(''.$this->tablePrefix.'user')->where(array("user_id"=>$userid))->find();
    		return $rs;
    	}
   }
    
}
?>