<?php
//角色权限模型
class RoleAuthModel extends CommonModel {
	
    //获取角色列表
	function getRoleList(){
	   $rs = $this->db->query('select * from '.$this->tablePrefix.'admin_user_role');
	   return $rs;
	}
	
	
	//获取角色名称
	function getRoleName($role_id){
		$rs = $this->db->query("select role_name from  ".$this->tablePrefix."admin_user_role where role_id=$role_id");
		return $rs[0]["role_name"];
	}
	
	
    //菜单分组树形结构
	function getMenuTree ($nowid="0") {
		$rs = $this->db->query('select * from '.$this->tablePrefix.'admin_menu');
		$abce.="&nbsp;&nbsp;";
		if($rs){
			foreach($rs as $array){
				if($nowid==$array[mid]) {
						$output.= "<OPTION value=\"".$array[mid]."\" selected>".$array[title]."</OPTION>\n";
				}else {
					    $output.= "<OPTION value=\"".$array[mid]."\" >".$array[title]."</OPTION>\n";
				}
			}
		}
		return $output;
	}
	
	//菜单组和规则列表
	function getMenuAuth(){
		$menulist = $this->db->query('select * from '.$this->tablePrefix.'admin_menu');
		
		foreach ($menulist as $key=>$v){
			$authlist = $this->db->query('select * from '.$this->tablePrefix.'admin_user_auth where g='.$v[mid]);
			$menulist[$key]["authlist"]=$authlist;
		}

		return $menulist;
	}
	
	/*
	 * 更新角色和规则关系
	 * @param  int     $role_id       角色id
	 * @param  array  $roleData   角色数据
	 * @param  array   $authids   规则数据id
	 * @return bool  
	 */
	 
	function setRoleAuth($role_id="0",$roleData=array(),$authids=array()){
		if($role_id>0){
			//更新角色
			$map["role_id"]=$role_id;
			$result = $this->table(''.$this->tablePrefix.'admin_user_role')->where($map)->save($roleData);
			//删除原来的角色规则关系表
			$this->table(''.$this->tablePrefix.'admin_user_roleauth_links')->where(array("role_id"=>$role_id))->delete();
			//插入新角色和规则关系
	   	    if($authids){
	   	   	    foreach($authids as $v){
	   	   	    	$data=array("role_id"=>$role_id,"auth_id"=>$v);
	   	   	    	$this->table(''.$this->tablePrefix.'admin_user_roleauth_links')->add($data);
	   	   	    }
	   	    }
		   	return true;
			
			
		}else{
		   //添加角色
		   //$sql =  'insert into '.$this->tablePrefix.'admin_menu value()';
		   $role_id = $this->table(''.$this->tablePrefix.'admin_user_role')->add($roleData);
		   if($role_id){
		   	   //插入角色和规则关系
		   	   if($authids){
		   	   	    foreach($authids as $v){
		   	   	    	$data=array("role_id"=>$role_id,"auth_id"=>$v);
		   	   	    	$this->table(''.$this->tablePrefix.'admin_user_roleauth_links')->add($data);
		   	   	    }
		   	   }
		   	   return true;
		   }else{
		   	   return false;
		   }
			
		}
	}
	
	
  /**
    *检查用户权限
    *$g=array(c=>控制器,m=>方法,s=>参数,type=>(allow|deny));
    *if($this->checkAuth(array('c'=>get_class($this),'m'=>__FUNCTION__,'s'=>''))){
    *        echo "可以访问";
    *    }else{
    *        echo "不能访问";
    *    }
    *
    **/
      function checkAuth($q=array()){
        $g_list=self::getAuthList();
        
        $n=count($g_list);
        for($i=0;$i<$n;$i++){
            if(self::checkYes($q,$g_list[$i])&&'allow'==$g_list[$i]['type']){
                $w_auth=true;
                break;
            }
        }
        for($i=0;$i<$n;$i++){
            if(self::checkNo($q,$g_list[$i])&&'deny'==$g_list[$i]['type']){
                $b_auth=true;
                break;
            }
        }
        if($w_auth&&!$b_auth){
            //可以访问
            return true;
            exit;
        }
        if(!$w_auth&&!$b_auth){
            //无授权,禁止访问;
            return false;
            exit;
        }
        if($w_auth&&$b_auth){
            //如对同一资源既授权又禁止,禁止访问;
            return false;
            exit;
        }
    }
	
    
    /*
     * 获取规则列表
     */
    function getAuthList(){
    	if($_SESSION["role_id"]){
    		$map["b.role_id"] = $_SESSION["role_id"];
    		$rs = $this->table(''.$this->tablePrefix.'admin_user_auth A')->join(''.$this->tablePrefix.'admin_user_roleauth_links 
    		b on a.auth_id=b.auth_id')->field("a.*")->where($map)->select();
    		return $rs;
    	}else{
    		return false;
    	}
    }
	
    

    /**
     *检查白名单
     *为真允许访问,权重没黑名单高
     *$q array(g,c,m,s,type);用户当前访问的
     *$g_list array(g,c,m,s,type);//用户已有的权限列表
     **/
    function checkYes($q,$g_list){
    
        if(!$g_list){
            //无记录,禁止访问
            return false;
        }elseif($q['c']){//先检查控制器

            if($q['c']==$g_list['c']){
          
                if($q['m']){//再检查mod
                	if(strpos($g_list['m'],"/")!=false){
                		$g_list['m']=explode("/",$g_list['m']);//后面修改加参数
                		$g_list['m']=$g_list['m'][0];
                	}
                	
                    if($q['m']==$g_list['m']){
                   	
                       if(!$g_list['s']) return true;
                      
                       $g_list['s'] = explode("/",$g_list['s']);
                       $urlDate = I();
                       $length = count($urlDate)-5;
                       $strArray = array();     
                       foreach($g_list['s'] as $key=>$v){
                       	  if($key%2==0){
                       	  	    
                       	  	    for($i=2;$i<=$length;$i++){
                       	  	    	 if($i%2==0){
                       	  	    	 
                       	  	    	 	if($urlDate[$i]==$v){
                       	  	    	 		$strArray[$key+1]=$i+1;
                       	  	    	 	}
                       	  	    	 }
                       	  	    }
                       	  }
                       }
                     
                       if(empty($strArray)) return false;
                       foreach($strArray as $key=>$v2){
                       	   
                       	     if($g_list['s'][$key]!=$urlDate[$v2]){
                       	     	return false;
                       	     }
                       }
                       return  true;
                   
                    }elseif(!$g_list['m']){return true;
                    }else{return false;}
                }else{return true;}
            }else{return false;}

        }
    }
    
    
   /*
    *检查黑名单
    */
    function checkNo($q,$g_list){//如果为真,则禁止操作
        if(!$g_list){//无记录,不限制
            return false;
        }elseif($q['c']){//先检查控制器
            if($q['c']==$g_list['c']){
                if($q['m']){//再检查mod
                    if($q['m']==$g_list['m']){
                        if($q['s']){
                            if($q['s']==$g_list['s']){
                                return true;
                            }else{return false;}
                        }else{return true;}
                    }else{return false;}
                }else{return true;}
            }else{return false;}

        }
    }
	
    
    /*
     * 获取左边菜单列表
     */
    function getLeftMenu($mid){
         if($_SESSION["role_id"]){
    		$map["b.role_id"] = $_SESSION["role_id"];
    		$map["a.g"]=$mid;
    		$map["a.ismenu"]=1;
    		$rs = $this->table(''.$this->tablePrefix.'admin_user_auth a')->join(''.$this->tablePrefix.'admin_user_roleauth_links 
    		b on a.auth_id=b.auth_id')->field("a.*")->where($map)->select();
    		return $rs;
    	}else{
    		return false;
    	}
    }
    
    
	/*
	 * 测试模型操作数据库
	 */
	
	function testDb(){
		 $rs=$this->table(''.$this->tablePrefix.'admin_menu')->select();
		 echo $this->getLastSql();
	     return $rs;
	}
	
}
?>