<?php
// +----------------------------------------------------------------------
// | ThinkPHP
// +----------------------------------------------------------------------
// | Copyright (c) 2007 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
// $Id$

/**
 * 格式化时间戳
 * @param int $time (必选)时间戳4
 * @param string $format (可选)时间格式，默认 Y-m-d H:i:s
 * @param string $default (可选)当 $time < $compare 时，返回的字符串，默认为空
 * @param int $compare (可选)认可的起始日期，默认为1262304000(2010-01-01)
 * @return string
 * */
function toDate($time, $format='Y-m-d H:i:s', $default='',$compare=1262304000) {
	if (empty($time) || $time<$compare) {
		return $default;
	}
	$format = str_replace ( '#', ':', $format );
	return date ($format, $time );
}

/**
	 * 安全过滤数据
	 *
	 * @param string	$str		需要处理的字符
	 * @param string	$type		返回的字符类型，支持，string,int,float,html
	 * @param maxid		$default	当出现错误或无数据时默认返回值
	 * @return 		mixed		当出现错误或无数据时默认返回值
	 */
function getStr($str,$type='string',$default=''){
	if($str==='')return $default;
	switch($type){
		case 'string':	//字符处理
			$_str=strip_tags($str);
			$_str=str_replace("'",'&#39;',$_str);
			$_str=str_replace("\"",'&quot;',$_str);
			$_str=str_replace("\\",'',$_str);
			$_str=str_replace("\/",'',$_str);
			
			break;
		case 'int':	//获取整形数据
			$_str=(int)$str;
			break;
		case 'float':	//获浮点形数据
			$_str=(float)$str;
			break;
		case 'html':	//获取HTML，防止XSS攻击
			//$_str=self::reMoveXss($str);
			break;
			
		default:	//默认当做字符处理
			$_str=strip_tags($str);
	}
	return trim($_str);
}

/*
 * 过滤create生产数组
 */
function getAarry($data){
	if(is_array($data)){
		foreach($data as $key=>$v){
			if(is_array($v)){
			    foreach($v as $key2=>$v2){
					$v[$key2] = getStr($v2);
				}
			    $data[$key] =   $v;	
			}else{
				$data[$key] = getStr($v);
			}
		}
	}
	return $data;
}


    /**
	 * 获取当前在线IP地址
	 * @param $format
	 * @return $format = 0 返回IP地址：127.0.0.1
	 *		    $format = 1 返回IP长整形：2130706433
	 */
function getIp($format=0) {
	global $_SGLOBAL;
	if(empty($_SGLOBAL['onlineip'])) {
		if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
			$onlineip = getenv('HTTP_CLIENT_IP');
		} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
			$onlineip = getenv('HTTP_X_FORWARDED_FOR');
		} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
			$onlineip = getenv('REMOTE_ADDR');
		} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
			$onlineip = $_SERVER['REMOTE_ADDR'];
		}
		preg_match("/[\d\.]{7,15}/", $onlineip, $onlineipmatches);
		$_SGLOBAL['onlineip'] = $onlineipmatches[0] ? $onlineipmatches[0] : 'unknown';
	}
	if(!$format) {
		return $_SGLOBAL['onlineip'];
	} else {
		return sprintf('%u',ip2long($_SGLOBAL['onlineip']));
	}
}

// 缓存文件
function cmssavecache($name = '', $fields = '') {
	$Model = D ( $name );
	$list = $Model->select ();
	$data = array ();
	foreach ( $list as $key => $val ) {
		if (empty ( $fields )) {
			$data [$val [$Model->getPk ()]] = $val;
		} else {
			// 获取需要的字段
			if (is_string ( $fields )) {
				$fields = explode ( ',', $fields );
			}
			if (count ( $fields ) == 1) {
				$data [$val [$Model->getPk ()]] = $val [$fields [0]];
			} else {
				foreach ( $fields as $field ) {
					$data [$val [$Model->getPk ()]] [] = $val [$field];
				}
			}
		}
	}
	$savefile = cmsgetcache ( $name );
	// 所有参数统一为大写
	$content = "<?php\nreturn " . var_export ( array_change_key_case ( $data, CASE_UPPER ), true ) . ";\n?>";
	file_put_contents ( $savefile, $content );
}

function cmsgetcache($name = '') {
	return DATA_PATH . '~' . strtolower ( $name ) . '.php';
}
function getStatus($status, $imageShow = true) {
	switch ($status) {
		case 0 :
			$showText = L("Forbid");
			$showImg = "<IMG SRC='" . __ROOT__.'/Public' . "/Images/locked.gif' WIDTH='20' HEIGHT='20' BORDER='0' ALT='".$showText."'>";
			break;
		case 2 :
			$showText = L("Pending");
			$showImg = "<IMG SRC='" . __ROOT__.'/Public' . "/Images/prected.gif' WIDTH='20' HEIGHT='20' BORDER='0' ALT='".$showText."'>";
			break;
		case - 1 :
			$showText = L("Delete");
			$showImg = "<IMG SRC='" . __ROOT__.'/Public' . "/Images/del.gif' WIDTH='20' HEIGHT='20' BORDER='0' ALT='".$showText."'>";
			break;
		case 1 :
		default :
			$showText = L("Normal");
			$showImg = "<IMG SRC='" . __ROOT__.'/Public' . "/Images/ok.gif' WIDTH='20' HEIGHT='20' BORDER='0' ALT='".$showText."'>";

	}
	return ($imageShow === true) ?  $showImg  : $showText;

}
function getDefaultStyle($style) {
	if (empty ( $style )) {
		return 'blue';
	} else {
		return $style;
	}

}
function IP($ip = '', $file = 'UTFWry.dat') {
	$_ip = array ();
	if (isset ( $_ip [$ip] )) {
		return $_ip [$ip];
	} else {
		import ( "ORG.Net.IpLocation" );
		$iplocation = new IpLocation ( $file );
		$location = $iplocation->getlocation ( $ip );
		$_ip [$ip] = $location ['country'] . $location ['area'];
	}
	
	return $_ip [$ip];
}


function getNodeName($id) {
	if (Session::is_set ( 'nodeNameList' )) {
		$name = Session::get ( 'nodeNameList' );
		return $name [$id];
	}
	$Group = D ( "Node" );
	$list = $Group->getField ( 'id,name' );
	$name = $list [$id];
	Session::set ( 'nodeNameList', $list );
	return $name;
}

function get_pawn($pawn) {
	if ($pawn == 0)
		return "<span style='color:green'>".L("No0")."</span>";
	else
		return "<span style='color:red'>".L("Yes0")."</span>";
}
function get_patent($patent) {
	if ($patent == 0)
		return "<span style='color:green'>".L("No0")."</span>";
	else
		return "<span style='color:red'>".L("Yes0")."</span>";
}


function getNodeGroupName($id) {
	if (empty ( $id )) {
		return L('Ungrouped');
	}
	if (isset ( $_SESSION ['nodeGroupList'] )) {
		return $_SESSION ['nodeGroupList'] [$id];
	}
	$Group = D ( "Group" );
	$list = $Group->getField ( 'id,title' );
	$_SESSION ['nodeGroupList'] = $list;
	$name = $list [$id];
	return $name;
}

function getCardStatus($status) {
	switch ($status) {
		case 0 :
			$show = L("Not").L("Enabled");
			break;
		case 1 :
			$show = L("Enable");
			break;
		case 2 :
			$show = L("In_Use");
			break;
		case 3 :
			$show = L("Disabled");
			break;
		case 4 :
			$show = L("Disposed");
			break;
	}
	return $show;

}

function showStatus($status, $id) {
	switch ($status) {
		case 0 :
			$info = "<a href='javascript:resume(" . $id . ")'>".L("Recover")."</a>";
			break;
		case 2 :
			$info = "<a href='javascript:pass(" . $id . ")'>".L("Approve")."</a>";
			break;
		case 1 :
			$info = "<a href='javascript:forbid(" . $id . ")'>".L("Disable")."</a>";
			break;
		case - 1 :
			$info = "<a href='javascript:recycle(" . $id . ")'>".L("Restore")."</a>";
			break;
	}
	return $info;
}

/**
 +----------------------------------------------------------
 * 获取登录验证码 默认为4位数字
 +----------------------------------------------------------
 * @param string $fmode 文件名
 +----------------------------------------------------------
 * @return string
 +----------------------------------------------------------
 */
function build_verify($length = 4, $mode = 1) {
	return rand_string ( $length, $mode );
}


function getGroupName($id) {
	if ($id == 0) {
		return '无上级组';
	}
	if ($list = F ( 'groupName' )) {
		return $list [$id];
	}
	$dao = D ( "Role" );
	$list = $dao->select ( array ('field' => 'id,name' ) );
	foreach ( $list as $vo ) {
		$nameList [$vo ['id']] = $vo ['name'];
	}
	$name = $nameList [$id];
	F ( 'groupName', $nameList );
	return $name;
}
function sort_by($array, $keyname = null, $sortby = 'asc') {
	$myarray = $inarray = array ();
	# First store the keyvalues in a seperate array
	foreach ( $array as $i => $befree ) {
		$myarray [$i] = $array [$i] [$keyname];
	}
	# Sort the new array by
	switch ($sortby) {
		case 'asc' :
			# Sort an array and maintain index association...
			asort ( $myarray );
			break;
		case 'desc' :
		case 'arsort' :
			# Sort an array in reverse order and maintain index association
			arsort ( $myarray );
			break;
		case 'natcasesor' :
			# Sort an array using a case insensitive "natural order" algorithm
			natcasesort ( $myarray );
			break;
	}
	# Rebuild the old array
	foreach ( $myarray as $key => $befree ) {
		$inarray [] = $array [$key];
	}
	return $inarray;
}

/**
	 +----------------------------------------------------------
 * 产生随机字串，可用来自动生成密码
 * 默认长度6位 字母和数字混合 支持中文
	 +----------------------------------------------------------
 * @param string $len 长度
 * @param string $type 字串类型
 * 0 字母 1 数字 其它 混合
 * @param string $addChars 额外字符
	 +----------------------------------------------------------
 * @return string
	 +----------------------------------------------------------
 */
function rand_string($len = 6, $type = '', $addChars = '') {
	$str = '';
	switch ($type) {
		case 0 :
			$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz' . $addChars;
			break;
		case 1 :
			$chars = str_repeat ( '0123456789', 3 );
			break;
		case 2 :
			$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' . $addChars;
			break;
		case 3 :
			$chars = 'abcdefghijklmnopqrstuvwxyz' . $addChars;
			break;
		case 4 :
			$chars = $addChars.'abcdefghijkmnpqrstuvwxyz23456789';
			break;
		default :
			// 默认去掉了容易混淆的字符oOLl和数字01，要添加请使用addChars参数
			$chars = 'ABCDEFGHIJKMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz23456789' . $addChars;
			break;
	}
	if ($len > 10) { //位数过长重复字符串一定次数
		$chars = $type == 1 ? str_repeat ( $chars, $len ) : str_repeat ( $chars, 5 );
	}
	if ($type != 4) {
		$chars = str_shuffle ( $chars );
		$str = substr ( $chars, 0, $len );
	} else {
		// 中文随机字
		for($i = 0; $i < $len; $i ++) {
			$str .= substr ( $chars, floor ( mt_rand ( 0, mb_strlen ( $chars, 'utf-8' ) - 1 ) ), 1 );
		}
	}
	return $str;
}
function pwdHash($password, $type = 'md5') {
	return hash ( $type, $password );
}

function getRequestParameterObject()
{
	if(!empty($_REQUEST['data'])) return $_REQUEST;
	return json_decode($_REQUEST['data']); 
}

function getRequestParameterArray()
{
	if(!empty($_REQUEST['data'])) return $_REQUEST;
	return json_decode($_REQUEST['data']);
}
/**
 * 导出EXCEL
 * @param string $filename 导出显示文件名
 * @param array $data 导出数据（二维数组格式，对应EXCEL单表二维） 
 */
function export_excel($filename, $data)
{
	Vendor('PHPExcel.PHPExcel');
	Vendor('PHPExcel.Writer.Excel5');
	
	$objPHPExcel = new PHPExcel();
	$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);
	$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);
	$objPHPExcel->setActiveSheetIndex(0);
	$objActSheet = $objPHPExcel->getActiveSheet();

	header("Pragma: public");
	header("Expires: 0");
	header("Cache-Control:must-revalidate, post-check=0, pre-check=0");
	header("Content-Type:application/force-download");
	header("Content-Type:application/vnd.ms-execl");
	header("Content-Type:application/octet-stream");
	header("Content-Type:application/download");
	header('Content-Disposition:attachment;filename='.$filename);
	header("Content-Transfer-Encoding:binary");
	$i = 1;
	foreach($data as $v)
	{
		$j = 'A';
		foreach($v as $v2)
		{
				$objActSheet->setCellValueExplicit($j++ . $i, $v2 , PHPExcel_Cell_DataType::TYPE_STRING);   
		}
		$i++;
	}
	$objWriter->save('php://output');
}
/**
* 给数组值加上单引号，并逗号拼接成串
* @param array $ary 待处理PHP数组
*/
function quote_string($ary)
{
    $tmp = array();
    foreach($ary as $v)
    {
    	$tmp[] = "'".$v."'";
	}
    
    return ! empty($tmp) ? implode(',',$tmp) : '';
}

/**
 * 根据统计频率生成时间段
 * @param string $start_date 日期格式字符串，开始日期
 * @param string $end_date 日期格式字符串，结束日期
 * @param string $period 频率，weekly,monthly
 */
function make_time_ary($start_date,$end_date,$period)
{
    if(empty($start_date)) return array();
    
    $ary = array();
    $edate = $start_date;
    switch($period)
    {
	    case 'weekly':
	    	while ($edate < $end_date)
	    	{
	    		$edate = date('Y-m-d', strtotime('+6 day',strtotime($start_date)));
	    		$ary[] = array($start_date,$edate);
	    		$start_date = date('Y-m-d', strtotime('+1 Week',strtotime($start_date)));
	    	}		
	    	break;
	    case 'monthly':
	    	while ($start_date < $end_date)
	    	{
	    		$tmp = date('Y-m-d', strtotime('+1 Month',strtotime($start_date)));
	    		$edate = date('Y-m-d', strtotime('-1 day',strtotime($tmp)));
	    		$ary[] = array($start_date,$edate);
	    		$start_date = $tmp;
	    	}		
	    	break;
    }
    
    return $ary;
}
/**
 * 读取分层的配置参数
 * @param string $path 参数路径(如QIS/vars.Offices读取Conf/QIS/vars.php下键值为Offices变量值
 */
function CC($path)
{
	if(strpos($path,'/') != false)
	{
		$tmp = explode('.', $path);
		$include_path = APP_PATH.'Conf/'.$tmp[0].'.php';
		$vals = include $include_path;
		$val = false;
		for($i=1;$i<count($tmp);$i++)
		{
			$key = $tmp[$i];
			if(isset($vals[$key]))
			{
				$val = $vals[$key];
			}
			else 
			{
				$val = false;
			}
		}
		return $val;
	}
	else 
	{
		return C($path);
	}
}

		/**
     +----------------------------------------------------------
     * 上传文件函数
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param string $savePath  上传文件保存路径
     +----------------------------------------------------------
     * @return string
     +----------------------------------------------------------
     */
   function uploadfile($savePath=""){
		import('ORG.Net.UploadFile');
		$upload = new UploadFile();// 实例化上传类
		$upload->maxSize  = C("MAX_SIZE")*1024 ;// 设置附件上传大小
		$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
		$upload->savePath =  C("QT_UPLOAD_URL").$savePath."/";// 设置附件上传目录
		$upload->thumb  = C("IS_THUMB");//是否生成缩略图
		$upload->thumbMaxWidth = C("THUMB_MAX_WIDTH");
		$upload->thumbMaxHeight = C("THUMB_MAX_HEIGHT");
		
		if(!$upload->upload()) {// 上传错误提示错误信息
		  return array("state"=>-1,"msg"=>$upload->getErrorMsg());
		}else{// 上传成功 获取上传文件信息
		  $info =  $upload->getUploadFileInfo();
		  $fileurl =$savePath."/".$info[0]["savename"];
		  $allFileUrl = $upload->savePath.$info[0]["savename"];
		  //生成水印
		  addwater($info[0]["extension"],$allFileUrl);
		  
		  return array("state"=>1,"msg"=>$info,"fileurl"=>$fileurl);
		}
		
	}
	
	/**
     +----------------------------------------------------------
     * 生成水印函数
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param string $extension 文件类型
     * @param string $fileurl  上传文件保存路径
     +----------------------------------------------------------
     * @return bool
     +----------------------------------------------------------
     */
     function addwater($extension,$fileurl){
	     
	     if(C("IS_WATER")){
			  	  //判断是否是图片类型
			  	  if(in_array($extension,array('jpg', 'gif', 'png', 'jpeg'))){
			  	  	  import("ORG.Util.Image.ThinkImage");
			  	  	  $water = new ThinkImage();
			  	  	  $water_position = C("WATER_POSITION");
				  	  if(C("WATER_TYPE")=="text"){
				  	  	   //加文字类型
				  	  	   $font =  LIBRARY_PATH."ORG/Util/Image/Fonts/".C("font"); //字体
				  	  	   $font_size = C("font_size"); //字体大小
				  	  	   $font_color = C("font_color"); //字体颜色
				  	  	   $water_text = C("WATER_TEXT"); //水印文字
				  	  	   $water->open('.'.$fileurl)->text($water_text,$font,$font_size,$font_color,$water_position)->save('.'.$fileurl);
				  	  }elseif(C("WATER_TYPE")=="img"){
				  	  	   $water_img = C("QT_UPLOAD_URL").C("WATER_PICURL");
				  	  	   $water->open($fileurl)->water($water_img,$water_position)->save($fileurl);
				  	  }
			  	  }
			return true; 	  
	     }else{
	     	return false;
	     }
     }
	
	/**
	 * 执行某个行为，允许返回值
	 * @param string $name 行为名称
	 * @param Mixed $params 传人的参数
	 * @return Mixed
	 */
	function BB($name, &$params=NULL) {
	    $class      = $name.'Behavior';
	    if(APP_DEBUG) {
	        G('behaviorStart');
	    }
	    $behavior   = new $class();
	    $res = $behavior->run($params);
	    if(APP_DEBUG) { // 记录行为的执行日志
	        G('behaviorEnd');
	        trace('Run '.$name.' Behavior [ RunTime:'.G('behaviorStart','behaviorEnd',6).'s ]','','INFO');
	    }
	    return $res;
	}
	
	/*
	 * 发送邮件
	 * @access public
	 * @param array $data //收件人地址
	 * $data['mailto'] 	= 	'i@pengyong.info'; //收件人
     * $data['subject'] =	'邮件正文标题';    //邮件标题
     * $data['body'] 	=	'邮件正文内容';    //邮件正文内容
	 * @return sring
	 */
	function sendEmail($data){
		import('ORG.Net.Email');
		$mail = new Email(); //实例化邮件类
		
	    //参数配置
	    $mail->smtp_port = C("EMAIL_PORT"); //端口
	    $mail->relay_host = C("EMAIL_SMTP");  //邮件smtp服务器
	    $mail->time_out = 60;  //超时
	    $mail->auth = C("SMTP_AUTH");  //是否服务器验证
	    $mail->email_address = C("EMAIL_ADDRESS");  //发送人地址
	    $mail->user = C("EMAIL_LOGIN");  //SMTP服务器账户名
	    $mail->pass = C("EMAIL_PASSWORD");  //SMTP服务器账户密码
	    if($mail->debug(false)->send($data)){
	    	return true;
	    }else{
	    	return false;
	    }	    	
	}

		/*
	 * 随机生成密码
	 * @param int $length 截取长度
	 * @return string
	 */
    function make_password($length=8)
	  {
	    // 密码字符集，可任意添加你需要的字符
	    $chars = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
	    'i', 'j', 'k', 'l','m', 'n', 'o', 'p', 'q', 'r', 's',
	    't', 'u', 'v', 'w', 'x', 'y','z', 'A', 'B', 'C', 'D',
	    'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L','M', 'N', 'O',
	    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y','Z',
	    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '!',
	    '@','#', '$', '%', '^', '&', '*', '(', ')', '-', '_',
	    '[', ']', '{', '}', '<', '>', '~', '`', '+', '=', ',',
	    '.', ';', ':', '/', '?', '|');
	
	    // 在 $chars 中随机取 $length 个数组元素键名
	    $keys = array_rand($chars, $length);
	    $password = '';
	    for($i = 0; $i < $length; $i++)
	    {
	        // 将 $length 个数组元素连接成字符串
	        $password .= $chars[$keys[$i]];
	    }
	    return $password;
	}
	
	/**
	 * 取积分等级图片
	 * @param int $userId 会员ID
	 * @param int $typeId 等级类别 1:借入, 2:借出（投资）
	 * @reutrn string
	 * */
	function getJiFenImg($userId, $typeId)
	{
		$arr = getJiFen($userId, $typeId);
		return '<img title="'.$arr['jifen'].'分" alt="'.$arr['jifen'].'分" src="'.C("SITE_IMG").'/credit/'.($arr['rank']['pic']).'">';
	}

	/**
	 * 取会员的积分和等级信息
	 * @param int $userId 会员ID
	 * @param int $typeId 等级类别 1:借入, 2:借出（投资）
	 * @reutrn array('jifen'=>总积分, 'rank'=>总积分对应的等级信息)
	 * */
	function getJiFen($userId, $typeId)
	{
		static $arr = array();
		$uk = "JF{$userId}";
		$tk = "RK{$typeId}";
		import("@.BLL.JiFen.JiFen");
		$obj = new JiFen();
		
		if(!isset($arr[$uk.$tk])) {
			$arr[$uk.$tk][$uk] = $obj->getJiFen($userId, $typeId);
			$arr[$uk.$tk][$tk] = $obj->getRank($userId, $typeId);
		}
		return array('jifen'=>$arr[$uk.$tk][$uk], 'rank'=>$arr[$uk.$tk][$tk]);
	}
	
	/*
	 * 发送手机短信
	 * @param string $phone
	 * @param string $content
	 * @return array
	 */
	function sendSms($phone,$content){
	    Vendor('Sms.JianZhou.nusoap');
		$client = new nusoap_client('http://www.jianzhou.sh.cn/JianzhouSMSWSServer/services/BusinessService?wsdl', true);
		$client->soap_defencoding = 'utf-8';
		$client->decode_utf8      = false;
		$client->xml_encoding     = 'utf-8';
		$err = $client->getError();
		$smsText = C("SITE_NAME");
		$smsText = "天天团购";
		if ($err) {
		    return false;
		}
		$params = array(
		    'account' => 'sdk_hhkg',
		    'password' => 'hhzx123456',
		    'destmobile' =>$phone,
		    'msgText' => $content."【{$smsText}】",
		);
		
		$result = $client->call('sendBatchMessage', $params, 'http://www.jianzhou.sh.cn/JianzhouSMSWSServer/services/BusinessService');
	
		if ($client->fault) {
		    //echo '<h2>Fault (This is expected)</h2><pre>'; print_r($result); echo '</pre>';
		    return true;
		} else {
		    $err = $client->getError();
		    if ($err) {
		        return false;
		    } else {
		        //echo '<h2>Result</h2><pre>'; print_r($result); echo '</pre>';
		        return true;
		    }
		}
	}
	
   /**
	 * 截取字符函数
	 * @param $string 要截取的字符串
	 * @param $len 截取长度
	 * @param $code 字符编码
	 * @param $prefix 新截取字符的前缀
	 * @param $add 处理后字符串加的后缀,如'...'
	 */
   function cutstr($string, $len, $code='utf-8', $prefix = '', $add = '') {
		if(is_array($string)) {
			foreach($string as $key => $val) {
				if(strlen($val) > $len) {
					$key = $prefix.$key;
					$string[$key] = mb_substr($val,0,$len,$code);
				} else {
					$key = $prefix.$key;
					$string[$key] = $val;
				}
			 }
		} else {
			if(strlen($string) > $len) {
				$string = mb_substr($string,0,$len,$code);
			}
		}
		return $string;
	}
    
	/*
	 *  金额格式化 3位数追加逗号
	 *  @param $num 数字
	 *  @return int
 	 */
	function num_format($num){
		 if(!is_numeric($num)){
		 return false;
		 }
		 $rvalue='';
		 $num = explode('.',$num);//把整数和小数分开
		 $rl = !isset($num['1']) ? '' : $num['1'];//小数部分的值
		 $j = strlen($num[0]) % 3;//整数有多少位
		 $sl = substr($num[0], 0, $j);//前面不满三位的数取出来
		 $sr = substr($num[0], $j);//后面的满三位的数取出来
		 $i = 0;
		 while($i <= strlen($sr)){
		 $rvalue = $rvalue.','.substr($sr, $i, 3);//三位三位取出再合并，按逗号隔开
		 $i = $i + 3;
		 }
		 $rvalue = $sl.$rvalue;
		 $rvalue = substr($rvalue,0,strlen($rvalue)-1);//去掉最后一个逗号
		 $rvalue = explode(',',$rvalue);//分解成数组
		 if($rvalue[0]==0){
		 array_shift($rvalue);//如果第一个元素为0，删除第一个元素
		 }
		 $rv = $rvalue[0];//前面不满三位的数
		 for($i = 1; $i < count($rvalue); $i++){
		 $rv = $rv.','.$rvalue[$i];
		 }
		 if(!empty($rl)){
		 $rvalue = $rv.'.'.$rl;//小数不为空，整数和小数合并
		 }else{
		 $rvalue = $rv;//小数为空，只有整数
		 }
		 return $rvalue;
 }
	/*
	 *  QQ互联登陆
 	 */
	function do_post($url, $data) {
		$ch = curl_init ();
		curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, TRUE );
		curl_setopt ( $ch, CURLOPT_POST, TRUE );
		curl_setopt ( $ch, CURLOPT_POSTFIELDS, $data );
		curl_setopt ( $ch, CURLOPT_URL, $url );
		$ret = curl_exec ( $ch );
		
		curl_close ( $ch );
		return $ret;
	}

	function get_url_contents($url) {

		
		$curl = curl_init ();
		
		// 设置你需要抓取的URL
		curl_setopt($curl, CURLOPT_URL,$url);
		//"UserTenderDowneyicontent/id/36245/uid/4459";
		// 设置header
		//curl_setopt($curl, CURLOPT_HEADER, 1);
		
		// 设置cURL 参数，要求结果保存到字符串中还是输出到屏幕上。
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		
		// 运行cURL，请求网页
		$data = curl_exec($curl);
		
		// 关闭URL请求
		curl_close($curl);

		return $data;
	}
	
	/*
	 * 账户截取函数
	 * @param string 截取字符
	 * @param $prefix 新截取字符的前缀
	 * @return string
	 */
	function bankcutstr($str,$prefix='******'){
		$length = strlen($str);
		return $str=mb_substr($str,0,3)."*****".mb_substr($str,$length-3,$length);
	}
	
	/**
	* 可逆的字符串加密函数
	* @param int $txtStream 待加密的字符串内容
	* @param string $type  加密方式
	* @param int $password 加密密码
	* @return string 加密后的字符串
	*/
	function enCryptksd($txtStream,$type,$password){		
		empty($password) && $password=C("CHARTKEY");
		if(empty($txtStream)){
			return ;
		}
		//密锁串，不能出现重复字符，内有A-Z,a-z,0-9,/,=,+,_,
		$lockstream = '7nopqr89LMmGH012345uvst=_jQRST-UwxkVWXYZabcdef+IJK6/lDEFABCNOPyzghi';
		if($type=="GET"){
		$lockstream = '7nopqr89LMmGH012345uvst=_jQRST-UwxkVWXYZabcdef+IJK6lDEFABCNOPyzghi';	
		}
		//随机找一个数字，并从密锁串中找到一个密锁值
		$lockLen = strlen($lockstream);
		$lockCount = rand(0,$lockLen-1);
		$randomLock = $lockstream[$lockCount];
		//结合随机密锁值生成MD5后的密码
		$password = md5($password.$randomLock);
		//开始对字符串加密
		$txtStream = base64_encode($txtStream);
		$tmpStream = '';
		$i=0;$j=0;$k = 0;
		for ($i=0; $i<strlen($txtStream); $i++) {
		$k = ($k == strlen($password)) ? 0 : $k;
		$j = (strpos($lockstream,$txtStream[$i])+$lockCount+ord($password[$k]))%($lockLen);
		$tmpStream .= $lockstream[$j];
		$k++;
		}
		return $tmpStream.$randomLock;
	}
	
	/**
	* 可逆的字符串解密函数
	* @param int $txtStream 待加密的字符串内容
	* @param string $type  加密方式
	* @param int $password 解密密码
	* @return string 解密后的字符串
	*/
	function deCryptksd($txtStream,$type,$password){
		empty($password) && $password=C("CHARTKEY");
		//密锁串，不能出现重复字符，内有A-Z,a-z,0-9,/,=,+,_,
		$lockstream = '7nopqr89LMmGH012345uvst=_jQRST-UwxkVWXYZabcdef+IJK6/lDEFABCNOPyzghi';
	    if($type=="GET"){
		$lockstream = '7nopqr89LMmGH012345uvst=_jQRST-UwxkVWXYZabcdef+IJK6lDEFABCNOPyzghi';	
		}
		$lockLen = strlen($lockstream);
		//获得字符串长度
		$txtLen = strlen($txtStream);
		//截取随机密锁值
		$randomLock = $txtStream[$txtLen - 1];
		//获得随机密码值的位置
		$lockCount = strpos($lockstream,$randomLock);
		//结合随机密锁值生成MD5后的密码
		$password = md5($password.$randomLock);
		//开始对字符串解密
		$txtStream = substr($txtStream,0,$txtLen-1);
		$tmpStream = '';
		$i=0;$j=0;$k = 0;
		for($i=0; $i<strlen($txtStream); $i++){
		$k = ($k == strlen($password)) ? 0 : $k;
		$j = strpos($lockstream,$txtStream[$i]) - $lockCount - ord($password[$k]);
		while($j < 0){
		$j = $j + ($lockLen);
		}
		$tmpStream .= $lockstream[$j];
		$k++;
		}
		return base64_decode($tmpStream);
	}
	
	
	/**
	* 加密cookie算法
	* @param int $sting 待加密的字符串内容
	* @return string 加密后的字符串
	*/
    function enCookies($uid){
         if(empty($uid)) return "";
         $pre = enCryptksd($uid);
         $cookie_key = "ABCDfggdhhjikfff23544888!dda@#$%587895";
         $string  = $pre."|".md5($cookie_key.$uid);
         return $string;
    }
    
    /*
     *解密cookie算法
     *
     */
    function deCookies($txtStream){
    	$str = explode("|",$txtStream);
    	$uid = (int)deCryptksd($str[0]);
    	$md5uid = $str[1];
    	$cookie_key = "ABCDfggdhhjikfff23544888!dda@#$%587895";
    	if(md5($cookie_key.$uid)==$md5uid){
    		return $uid;
    	}
    }
	
	/*
	 * 敏感字符过滤
	 * @param $string过滤内容
	 * @return string 
	 */
	function replaceCharacter($string){
		$Character = "借款,担保,房产,贷款,商铺,测试,抵押,投资";
		$CharacterArray = explode(",",$Character);
		foreach ($CharacterArray as $v){
			$replaceone = cutstr($v,1);
     		$replace = str_replace($replaceone,$replaceone." .",$v);
     		$string = str_replace($v,$replace,$string);
		}
	    return $string;
	}
	
	 /**
	 * 截取中文字符串
	 */
	function msubstr($str, $start=0, $length, $charset="utf-8", $suffix=false){
		if(function_exists("mb_substr")){
			if($suffix)
				return mb_substr($str, $start, $length, $charset)."...";
			else
				return mb_substr($str, $start, $length, $charset);
		}elseif(function_exists('iconv_substr')) {
			if($suffix)
				return iconv_substr($str,$start,$length,$charset)."...";
			else
				return iconv_substr($str,$start,$length,$charset);
		}
		$re['utf-8'] = "/[x01-x7f]|[xc2-xdf][x80-xbf]|[xe0-xef][x80-xbf]{2}|[xf0-xff][x80-xbf]{3}/";
		$re['gb2312'] = "/[x01-x7f]|[xb0-xf7][xa0-xfe]/";
		$re['gbk'] = "/[x01-x7f]|[x81-xfe][x40-xfe]/";
		$re['big5'] = "/[x01-x7f]|[x81-xfe]([x40-x7e]|xa1-xfe])/";
		preg_match_all($re[$charset], $str, $match);
		$slice = join("",array_slice($match[0], $start, $length));
		if($suffix) return $slice."…";
		return $slice;
	}
	
	
	/*
	 * 丰付加密
	 */
	function HmacMd5($data, $key) {
	// RFC 2104 HMAC implementation for php.
	// Creates an md5 HMAC.
	// Eliminates the need to install mhash to compute a HMAC
	// Hacked by Lance Rushing(NOTE: Hacked means written)

	//需要配置环境支持iconv，否则中文参数不能正常处理
	$key = iconv("GB2312", "UTF-8", $key);
	$data = iconv("GB2312", "UTF-8", $data);

	$b = 64; // byte length for md5
	if (strlen($key) > $b) {
		$key = pack("H*", md5($key));
	}
	$key = str_pad($key, $b, chr(0x00));
	$ipad = str_pad('', $b, chr(0x36));
	$opad = str_pad('', $b, chr(0x5c));
	$k_ipad = $key ^ $ipad;
	$k_opad = $key ^ $opad;

	return md5($k_opad . pack("H*", md5($k_ipad . $data)));
    }
	
    /*
     * 金额单位
     * @params float $amout  金额
     * @params int   $type   类型
     * @return string
     */
    function AmountUnit($amount,$type=0){
    	switch($type){
    		case 0:
    			$num=$amount;
    			$unit = "元";
    			break;
    		case 1:
    			//万
    			$num=$amount/10000;
    			$unit = "万";
    			break;
    		case 2:
    			//亿
    			$num=$amount/100000000;
    			$unit = "亿";
    			break;
    		case 3:
    			//万 (无单位)
    			$num=$amount/10000;
    			$unit = "";	
    		default:
    			$num = $amount;
    			$unit = "";	
    			break;			
    	}
    	$num=sprintf("%.2f",substr(sprintf("%.4f", $num), 0, -2));
    	return $num.$unit;
    }
    
    function getPasstime($userId)
    {
    	static $t=0, $ex=false;
    	
    	if(!$ex) {
    		$obj = D("Passlog");
    		$map['user_id'] = $userId;
    		$rs  = $obj->where($map)->field("addtime")->order("addtime desc")->find();
    		if($rs["addtime"]){
    			$t = $rs["addtime"];
    		}
    		$ex = true;
    	}
    	
    	return $t;
    }
?>