<?php
abstract class BaseAction extends Action
{
	//分组名
	protected $_group_name = '';
		
	//错误信息
	protected $_error_array = array();
		
	//Model 名称
	protected $_model_name = '';
	
	//当前的数据库模型对象
	protected $_CUR_MODEL = null;
	
	/**
	 * @return boolean false
	 * */
	function setError($str)
	{
		if(is_array($str)) {
			$this->_error_array = array_merge($str, $this->_error_array);
		} else {
			$this->_error_array[] = $str;
		}
		$this->_error_array = array_unique($this->_error_array);
		
		return false;
	}
	
	/**
	 * 提取错误信息
	 * @param $isLog boolean 当处于调试模式时是否要将错误信息写入日志，默认值：true
	 * @return array
	 * */
	function getError($isLog = true)
	{
		if($isLog && C('APP_DEBUG') && !empty($this->_error_array)) Log::write(print_r($this->_error_array, true));
		return $this->_error_array;
	}
	
	/**
	 * 提取错误字符串
	 * @param array $arr (可选)错误信息数组
	 * @param boolean $isBegin true（默认）:$arr 为空时，错误信息为当前实例的错误信息数组; false : 错误信息强行为 $arr
	 * @return string
	 * */
	function getErrorString($arr = array(), $isBegin=true)
	{
		static $cnt = 0;
		if($isBegin && empty($arr)) $arr=$this->_error_array;
		if(empty($arr)) return '';
		$str = '';
		foreach($arr as $k=>$v) {
			if(is_array($v)) $str .= $this->getErrorString($v, false);
			elseif(!empty($v)) $str .= '['.(++$cnt).']: '.$v;
		}
		return $str;
	}
	
	/**
	 * 取跟当前Action相关的Model名称
	 * @return string
	 * */
	function getModelName()
	{
		$name = $this->_model_name;
		empty($name) && $name = $this->getActionName();
		return $name;
	}
	
	/**
	 * 获得当前模块的数据库类型对象
	 * @return object#Model
	 * */
	function getMainModel()
	{
		if(empty($this->_CUR_MODEL)) {
			$name = $this->getModelName();
			$this->_CUR_MODEL = $this->_D($name);
		}
		return $this->_CUR_MODEL;
	}
		
	protected function _D($name)
	{
		!empty($this->_group_name) && $name = $this->_group_name.'/'.$name;
		$obj = D($name);
		empty($obj) && $obj=M($name);
		return $obj;
	}
	
	protected function _A($name)
	{
		!empty($this->_group_name) && $name = $this->_group_name .'/'.$name;
		return A($name);
	}
	
	/**
	 * 读取 Relation 目录下的数据模型
	 * */
	protected function _R($name)
	{
		return D("Relation/{$name}Relation");
	}
	
	/**
	 * 读取 View 目录下的数据模型
	 * */
	protected function _V($name)
	{
		return D("View/{$name}View");
	}
	
	 /**
     * Ajax方式返回数据到客户端
     * @access protected
     * @param mixed $data 要返回的数据
     * @param String $type AJAX返回数据格式
     * @return void
     */
    protected function ajaxReturn($data, $type='') {
       if(func_num_args()>2) {// 兼容3.0之前用法
            $args           =   func_get_args();
            $info           =   array();
            $info['data']   =   array_shift($args);
            $info['info']   =   array_shift($args);
            $info['status'] =   array_shift($args);
            $data           =   $info;
            $type           =   $args?array_shift($args):'';
        }
        if(empty($type)) $type  =   C('DEFAULT_AJAX_RETURN');
        switch (strtoupper($type)){
            case 'JSON' :
                // 返回JSON数据格式到客户端 包含状态信息
                header('Content-Type:text/html; charset=utf-8');
                exit(json_encode($data));
            case 'XML'  :
                // 返回xml格式数据
                header('Content-Type:text/xml; charset=utf-8');
                exit($this->xml_encode($data));
            case 'JSONP':
                // 返回JSON数据格式到客户端 包含状态信息
                header('Content-Type:application/json; charset=utf-8');
                $handler  =   isset($_GET[C('VAR_JSONP_HANDLER')]) ? $_GET[C('VAR_JSONP_HANDLER')] : C('DEFAULT_JSONP_HANDLER');
                exit($handler.'('.json_encode($data).');');  
            case 'EVAL' :
                // 返回可执行的js脚本
                header('Content-Type:text/html; charset=utf-8');
                exit($data);            
            default     :
                // 用于扩展其他返回格式数据
                tag('ajax_return',$data);
        }
    }
	
    /**
     * 将匿名函数转换为create_function 方式
     * @param $str 格式必须以 function([参数]){}方式的字符，参数列表不允许有注释和换行
     * @return string 生成过程发生错误时返回空字符串
     * */
    protected function _anon($str)
    {
    	if(phpversion() >= '5.3') {
    		eval('$fun='.$str.';');
    		return $fun;
    	}
    	
    	$str = trim($str);
    	$cOffset = strpos($str,'{', 10); //偏移量为 function() 最基本的10个字符
    	if(!$cOffset) return '';
    	$code = substr($str, $cOffset+1); //取得代码段, 加 1 是为了把这段字符串的 { 字符去掉
    	$code = preg_replace("/\};*$/", '', trim($code));
    	if(empty($code)) return '';
    	
    	$begin = 8;
    	$len = $cOffset - $begin - 1;
     	$args = trim(substr($str, $begin, $len)); //8 截取function这8个字符之后的 $len 长度的字符
   		$args = substr($args, 1); 			//去掉开头的 ( 字符
   		$args = trim(substr($args, 0, -1)); //去掉末尾的 ) 字符
   		if($args && substr($args, 0,1)!='$') { //如果第一个字符不是 $ ，即非法
   			return '';
   		}
    	
   		$fun = create_function($args, $code);
   		return $fun;
     }
    

	/**
	 * XML编码
	 * @param mixed $data 数据
	 * @param string $root 根节点名
	 * @param string $item 数字索引的子节点名
	 * @param string $attr 根节点属性
	 * @param string $id   数字索引子节点key转换的属性名
	 * @param string $encoding 数据编码
	 * @return string
	 */
	function xml_encode($data, $root='think', $item='item', $attr='', $id='id', $encoding='utf-8') {
	    if(is_array($attr)){
	        $_attr = array();
	        foreach ($attr as $key => $value) {
	            $_attr[] = "{$key}=\"{$value}\"";
	        }
	        $attr = implode(' ', $_attr);
	    }
	    $attr   = trim($attr);
	    $attr   = empty($attr) ? '' : " {$attr}";
	    $xml    = "<?xml version=\"1.0\" encoding=\"{$encoding}\"?>";
	    $xml   .= "<{$root}{$attr}>";
	    $xml   .= $this->data_to_xml($data, $item, $id);
	    $xml   .= "</{$root}>";
	    return $xml;
	}
	
	/**
	 * 数据XML编码
	 * @param mixed  $data 数据
	 * @param string $item 数字索引时的节点名称
	 * @param string $id   数字索引key转换为的属性名
	 * @return string
	 */
	function data_to_xml($data, $item='item', $id='id') {
	    $xml = $attr = '';
	    foreach ($data as $key => $val) {
	        if(is_numeric($key)){
	            $id && $attr = " {$id}=\"{$key}\"";
	            $key  = $item;
	        }
	        $xml    .=  "<{$key}{$attr}>";
	        $xml    .=  (is_array($val) || is_object($val)) ? 
	        			$this->data_to_xml($val, $item, $id) : 
	        			(is_numeric($val)||is_bool($val)||empty($val) ?$val:"<![CDATA[ {$val} ]]>");
	        $xml    .=  "</{$key}>";
	    }
	    return $xml;
	}
    /**
     * 默认不允许不存在方法名时，而直接读取模板的情况发生
     * */
    /*
	protected function _empty($method, $args) {
    	$this->display("Public:404");
    }*/
    
}
?>