<?php
class UserBaseAction extends KDBaseAction
{
	//可以跳过的验证的方法
   protected $_not_auth_action = array();
	
   protected $_userid;

   
   protected function _initialize(){
   		
  		$this->_userid =$this->getloginStatus();
  		$this->_lasttime =cookie("lasttime");
		$nav = $this->getActionName();
		$this->assign('nav', strtolower($nav));
		$actionArray = array("UserInfo","Recharge","UserApprove","UserMessage","UserTender","UserBorrow","UserPersonal","Cash","UserRating","UserMessage","UserRemind");
		if(in_array($nav,$actionArray)){
		   $this->assign('nav',"user");
		}
		
		$unav = ACTION_NAME;
		$this->assign('unav', strtolower($unav));
		if(!$this->_userid && !in_array(ACTION_NAME, $this->_not_auth_action)){
			if($this->_isAPPRequest()) {
				$err = array();
				$err['data'] = array();
				$err['info'] = '用户未登录';
				$err['status'] = 999;
				$this->_returnAPP($err);
			} else {
   			//$this->redirect('/Login/index');
   			header('Location: https://www.ksudai.com/Login');
			} 
   			exit();
   		}
   		
   		if($this->_userid){
   		     $lasttime = $this->getPasstime();
   		     if($this->_lasttime<$lasttime){
   		     	//$this->redirect('/Login/index');
   		     	header('Location: https://www.ksudai.com/Login'); 
   			    exit();
   		     }
   		}
		
   }
   
   /*
    * 获取用户信息
    * @param int $uid
    * @return string
    */
   function getUser($field=""){
   	     if(empty($field)){
   	     	$field = "*";
   	     }
   	     $this->_obj = $this->_D("user");
   	     $rs = $this->_obj->where(array("user_id"=>$this->_userid))->field("$field")->find();
   	     return $rs;
   }
   
   /*
    * 获取用户账户信息
    * @return array
    */
   function getAccount($field=""){
         if(empty($field)){
   	     	$field = "*";
   	     }
   	     $this->_obj = $this->_D("account");
   	     $rs = $this->_obj->where(array("user_id"=>$this->_userid))->field("$field")->find();
   	     return $rs;
   }
   
   /*
    * 密码修改日志
    */
  protected function getPasstime(){
  	  return getPasstime($this->_userid);
  }
  
  /*
    * 获取登录id
    */
   protected function getloginStatus(){
   	  //加密cookie
   	  $uid = (int)deCookies($_COOKIE["user_id"]);
   	  if(is_int($uid)){
   	      $addtime = getPasstime($uid);
   	      if($_COOKIE["lasttime"]>$addtime){
   	      	return $uid;
   	      }
   	  }
   	  
   }
   
	protected function _checkUDID(){
		if(empty($this->_userid)) return;
		import("@.BLL.UDID.Udid");
		$obj = new Udid();
		$obj->check();
	}

    //设置cookie
	function ssetCookie($userInfo,$stime){
		 setcookie("user_id",enCookies($userInfo["user_id"]),time()+3600*$stime,"/",str_replace("http://www","",C("SITE_URL")),$_SERVER['SERVER_PORT']==443?0:0);
		 setcookie("lasttime",time(),time()+3600*$stime,"/",str_replace("http://www","",C("SITE_URL")),$_SERVER['SERVER_PORT']==443?0:0);
		 //setcookie("username",$userInfo["username"],time()+3600*$stime,"/",str_replace("http://","",C("SITE_URL")));
	}
	
	function clearCookie()
	{
		$t = time();
		setcookie("user_id","",$t-1000,"/",str_replace("http://www","",C("SITE_URL")),$_SERVER['SERVER_PORT']==443?0:0);
		setcookie("lasttime","",$t-1000,"/",str_replace("http://www","",C("SITE_URL")),$_SERVER['SERVER_PORT']==443?0:0);
	}
}