<?php
class KDBaseWidget extends Widget
{
	protected $_res = array();
	protected $_group_name = '';
	protected $_userid = 0;
	
	function render($data)
	{
		$this->_res = $data;
		$this->_userid = deCookies($_COOKIE['user_id']);
		
		$name = "_{$data['W_TYPE']}";
		if(method_exists($this, $name)) {
			$content = $this->$name();
		} else {
			$content = $this->renderFile($data['W_TYPE'], array('vo'=>$data));
		}
		return $content;
	}
	
	protected function _D($name)
	{
		!empty($this->_group_name) && $name = $this->_group_name.'/'.$name;
		$obj = D($name);
		empty($obj) && $obj=M($name);
		return $obj;
	}
	
	protected function _A($name)
	{
		!empty($this->_group_name) && $name = $this->_group_name .'/'.$name;
		return A($name);
	}
	
	/**
	 * 读取 Relation 目录下的数据模型
	 * */
	protected function _R($name)
	{
		return D("Relation/{$name}Relation");
	}
	
	/**
	 * 读取 View 目录下的数据模型
	 * */
	protected function _V($name)
	{
		return D("View/{$name}View");
	}
	
/**
	 * 公用数据查询
	 * @param Object#Model $model (必选)查询数据库模型, $model 应在传入前完成where、order ，relation 等参数
	 * @param array $urlArr (可选)用于生成 分页链接条件的条件组
	 * @param int $listRows (可选)每页的显示记录数，默认:20
	 * @param boolean $isPage (可选)是否需要分页，默认:true
	 * @param boolean $isGroupRow (可选)是否需要按照分组后统计记录行数
	 * @return false/array
	 * */
	protected function _SH($model, $urlArr=array(), $listRows=20, $isPage=true, $isGroupRow=false)
	{
		$res = array('res'=>array(), 'page'=>'');
		if($isPage) {
			$obj = clone($model);
			if($isGroupRow) { //按照分组后统计记录行数
				$str = $obj->select(false);
				$sql = "select count(*) as tp_count from {$str} a";
				$rs = $obj->query($sql); 
				$len = intval($rs[0]['tp_count']);
			} else {
	    		$len = $obj->count();
			}
	    	unset($obj);
	    	
	    	import("ORG.Util.Page");
	    	$listRows = intval($listRows);
	    	$listRows<1 && $listRows = 20;
	    	$objPage = new Page(intval($len), $listRows);
	    	$parameter = array();
	    	foreach ($urlArr as $k=>$v) {
	    		$parameter[] = "{$k}={$v}";
	    	}
	    	$objPage->parameter = implode("&", $parameter);

	    	$model->limit($objPage->firstRow,$objPage->listRows);
	    	
	   		$res['page'] = $objPage->Show();
	   		$res['pageObj'] = $objPage;
		}
     	$res['list'] = $model->select();
    	
    	return $res;
	}
}
?>